package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.RoleOrgRelListener;
import com.xforceplus.tenant.security.core.domain.ICreater;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({RoleOrgRelListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "role_org_rel")
public class RoleOrgRel implements ICreater {
    private Long relId;
    private Long roleId;
    private Long orgId;
    /**
     * 是否需要默认绑定组织内用户
     */
    private Boolean defaultBindUser;
    private String createrId;
    private String createrName;
    private Date createTime;

    @JsonIgnore
    private Role role;

    @JsonIgnore
    private OrgStruct org;

    @Id
    @Column(name = "rel_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getRelId() {
        return relId;
    }

    @Basic
    @Column(name = "role_id", nullable = false)
    public Long getRoleId() {
        return roleId;
    }

    @Basic
    @Column(name = "org_id", nullable = false)
    public Long getOrgId() {
        return (orgId != null && orgId > 0) ? orgId : null;
    }

    @Basic
    @Column(name = "default_bind_user", nullable = false)
    public Boolean getDefaultBindUser() {
        return defaultBindUser;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public OrgStruct getOrg() {
        return org;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Role getRole() {
        return role;
    }

    @Basic
    @Column(name = "create_user_id", updatable = false)
    @Override
    public String getCreaterId(){
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time", updatable = false)
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleOrgRel that = (RoleOrgRel) o;
        if (relId == null) {
            if (that.relId != null) {
                return false;
            } else {
                return Objects.equals(orgId, that.orgId) &&
                        Objects.equals(roleId, that.roleId);
            }
        } else {
            return relId.equals(that.relId);
        }
    }

    @Override
    public int hashCode() {
        if (relId != null) {
            return Objects.hash(relId);
        }
        return Objects.hash(orgId, roleId);
    }
}
