package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.jpa.listener.RoleUserRelListener;
import com.xforceplus.tenant.security.core.domain.ICreater;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import javax.persistence.*;
import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({RoleUserRelListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_role_user_rel")
public class RoleUserRel implements ICreater {
    private Long id;
    private Long roleId;
    private Long userId;
    private Long tenantId;
    private String createrId;
    private String createrName;
    private Date createTime;

    @JsonIgnore
    private Role role;

    @JsonIgnore
    private User user;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "role_id", nullable = false)
    public Long getRoleId() {
        return (roleId != null && roleId > 0) ? roleId : null;
    }

    @Basic
    @Column(name = "user_id", nullable = false)
    public Long getUserId() {
        return (userId != null && userId > 0) ? userId : null;
    }

    @Basic
    @Column(name = "tenant_id")
    public Long getTenantId() {
        return tenantId;
    }

    @Basic
    @Column(name = "create_user_id")
    public String getCreaterId() {
        return createrId;
    }

    @Basic
    @Column(name = "create_user_name")
    public String getCreaterName() {
        return createrName;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "role_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Role getRole() {
        return role;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY, optional = false)
    @JoinColumn(name = "user_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public User getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleUserRel)) {
            return false;
        }
        RoleUserRel that = (RoleUserRel) o;
        if (id == null) {
            if (that.id != null) {
                return false;
            } else {
                return Objects.equals(roleId, that.roleId) &&
                        Objects.equals(userId, that.userId);
            }
        } else {
            return id.equals(that.id);
        }
    }

    @Override
    public int hashCode() {
        if (this.id != null) {
            return Objects.hash(this.id);
        }
        return Objects.hash(roleId, userId);
    }

    @Override
    public String toString() {
        return "RoleUserRel{" + "id=" + id + ", roleId=" + roleId + ", userId=" + userId + '}';
    }
}
