package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ServicePackageDto;
import com.xforceplus.domain.resource.view.ServicePackageView;
import com.xforceplus.domain.resource.view.TenantServicePackageView;
import com.xforceplus.jpa.listener.ServicePackageListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;


/**
 * @author geewit
 */
@SuppressWarnings("all")
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({ServicePackageListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_service_package")
public class ServicePackage extends ServicePackageDto implements Serializable {
    @JsonIgnore
    private List<ServiceResourcesetRel> serviceResourcesetRels;

    @JsonIgnore
    private List<CompanyServiceRel> companyServiceRels;

    @JsonView(ServicePackageView.ServicePackageInfo.class)
    private Set<Resourceset> resourcesets;

    @JsonIgnore
    private List<TenantServiceRel> tenantServiceRels;

    @JsonView({TenantServicePackageView.TenantServicePackageInfo.class})
    private App app;

    public ServicePackage() {
    }

    public ServicePackage(Long servicePackageId, String servicePackageName, Long appId) {
        super(servicePackageId, servicePackageName, appId);
    }

    @Override
    @Id
    @Column(name = "service_package_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getServicePackageId() {
        return servicePackageId;
    }

    @Override
    @Basic
    @Column(name = "app_id")
    public Long getAppId() {
        return appId;
    }

    @Override
    @Basic
    @Column(name = "service_package_code")
    public String getServicePackageCode() {
        return servicePackageCode;
    }

    @Override
    @Basic
    @Column(name = "service_package_name")
    public String getServicePackageName() {
        return servicePackageName;
    }

    @Override
    @Basic
    @Column(name = "service_package_desc")
    public String getServicePackageDesc() {
        return servicePackageDesc;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Basic
    @Column(name = "create_user_id")
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "create_user_name")
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @ApiModelProperty(value = "功能集集合")
    @Transient
    public Set<Resourceset> getResourcesets() {
        return this.resourcesets;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "app_id", referencedColumnName = "app_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public App getApp() {
        return app;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = ServiceResourcesetRel_.SERVICE_PACKAGE)
    public List<ServiceResourcesetRel> getServiceResourcesetRels() {
        return serviceResourcesetRels;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = CompanyServiceRel_.SERVICE_PACKAGE)
    public List<CompanyServiceRel> getCompanyServiceRels() {
        return companyServiceRels;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @OneToMany(fetch = FetchType.LAZY, mappedBy = TenantServiceRel_.SERVICE_PACKAGE)
    public List<TenantServiceRel> getTenantServiceRels() {
        return tenantServiceRels;
    }

    @JsonView(ServicePackageView.ServicePackageInfo.class)
    @Transient
    public String getAppName() {
        return appName;
    }

    @Transient
    public void postLoad() {
        if (this.app != null) {
            this.appName = this.app.getAppName();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
