package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;

import javax.persistence.*;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_service_resourceset_rel")
public class ServiceResourcesetRel implements Serializable {
    private Long id;
    private Long servicePackageId;
    private Long resourcesetId;
    private String createUserName;

    @JsonIgnore
    private Resourceset resourceset;

    @JsonIgnore
    private ServicePackage servicePackage;

    @JsonIgnore
    @Transient
    private transient String servicePackageName;

    @JsonIgnore
    @Transient
    private transient String servicePackageCode;

    @JsonIgnore
    @Transient
    private transient String resourcesetName;

    @JsonIgnore
    @Transient
    private transient String resourcesetCode;

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "service_package_id", nullable = false)
    public Long getServicePackageId() {
        return (servicePackageId != null && servicePackageId > 0) ? servicePackageId : null;
    }

    @Basic
    @Column(name = "resourceset_id", nullable = false)
    public Long getResourcesetId() {
        return (resourcesetId != null && resourcesetId > 0) ? resourcesetId : null;
    }

    @Basic
    @Column(name = "create_user_name", updatable = false)
    public String getCreateUserName() {
        return createUserName;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "service_package_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public ServicePackage getServicePackage() {
        return servicePackage;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "resourceset_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Resourceset getResourceset() {
        return resourceset;
    }

    @Transient
    public String getServicePackageName() {
        return servicePackageName;
    }

    @Transient
    public String getServicePackageCode() {
        return servicePackageCode;
    }

    @Transient
    public String getResourcesetName() {
        return resourcesetName;
    }

    @Transient
    public String getResourcesetCode() {
        return resourcesetCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceResourcesetRel)) {
            return false;
        }
        ServiceResourcesetRel that = (ServiceResourcesetRel) o;
        if (id == null) {
            if (that.id != null) {
                return false;
            } else {
                return Objects.equals(servicePackageId, that.servicePackageId) &&
                        Objects.equals(resourcesetId, that.resourcesetId);
            }
        } else {
            return id.equals(that.id);
        }
    }

    @Override
    public int hashCode() {
        if (this.id != null) {
            return Objects.hash(this.id);
        }
        return Objects.hash(servicePackageId, resourcesetId);
    }

    @Override
    public String toString() {
        return "ServiceResourcesetRel{" +
                "id=" + id +
                ", servicePackageId=" + servicePackageId +
                ", resourcesetId=" + resourcesetId +
                ", createUserName=" + createUserName +
                '}';
    }
}
