package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.jpa.listener.TagListener;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;

@Setter
@Entity
@Table(name = "bss_tag")
@EntityListeners({TagListener.class})
@DynamicInsert
@DynamicUpdate
public class Tag implements IOperator  {
    @JsonView(View.class)
    private Long id;
    @JsonView(View.class)
    private String tagName;
    @JsonView(View.class)
    private String tagCode;
    @JsonView(View.class)
    private String tagDesc;
    @JsonIgnore
    private Boolean deleted;
    @JsonIgnore
    private String createrId;
    @JsonIgnore
    private String createrName;
    @JsonIgnore
    private Date createTime;
    @JsonIgnore
    private String updaterId;
    @JsonIgnore
    private String updaterName;
    @JsonIgnore
    private Date updateTime;

    @Id
    @Column(name = "id", nullable = false)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "tag_name", nullable = false, length = 12)
    public String getTagName() {
        return tagName;
    }

    @Basic
    @Column(name = "tag_desc", nullable = false, length = 100)
    public String getTagDesc() {
        return tagDesc;
    }

    @Basic
    @Column(name = "tag_code", nullable = false, length = 12)
    public String getTagCode() {
        return tagCode;
    }

    @Basic
    @Column(name = "deleted", nullable = false)
    public Boolean getDeleted() {
        return deleted;
    }

    @Override
    @Basic
    @Column(name = "creater_id")
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "creater_name")
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "updater_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "updater_name", length = 50)
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }
}