package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.jpa.listener.TagRelListener;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;


@Setter
@Entity
@Table(name = "bss_tag_rel")
@EntityListeners({TagRelListener .class})
@DynamicInsert
@DynamicUpdate
public class TagRel implements IOperator {

    private Long id;

    private Long tagId;
    @JsonIgnore
    private Integer entityType;
    @JsonIgnore
    private Long entityId;
    @JsonIgnore
    private Boolean deleted;
    @JsonIgnore
    private String createrId;
    @JsonIgnore
    private String createrName;
    @JsonIgnore
    private Date createTime;
    @JsonIgnore
    private String updaterId;
    @JsonIgnore
    private String updaterName;
    @JsonIgnore
    private Date updateTime;

    @JsonIgnore
    private Tenant tenant;

    @JsonIgnore
    private Company company;


    private Tag tag;

    @Id
    @Column(name = "id", nullable = false)
    public Long getId() {
        return id;
    }

    @Basic
    @Column(name = "entity_id")
    public Long getEntityId() {
        return entityId;
    }

    @Basic
    @Column(name = "entity_type")
    public Integer getEntityType() {
        return entityType;
    }

    @Basic
    @Column(name = "tag_id")
    public Long getTagId() {
        return tagId;
    }

    @Basic
    @Column(name = "deleted")
    public Boolean getDeleted() {
        return deleted;
    }

    @Override
    @Basic
    @Column(name = "creater_id")
    public String getCreaterId() {
        return createrId;
    }

    @Override
    @Basic
    @Column(name = "creater_name")
    public String getCreaterName() {
        return createrName;
    }

    @Override
    @ApiModelProperty(value = "创建时间")
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "updater_id")
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Basic
    @Column(name = "updater_name")
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @ApiModelProperty(value = "创建时间")
    @JsonView({View.class})
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "entity_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public Tenant getTenant() {
        return tenant;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "entity_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    @LazyToOne(LazyToOneOption.NO_PROXY)
    public Company getCompany() {
        return company;
    }

    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tag_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tag getTag() {
        return tag;
    }
}