package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.tenant.TenantServicePackageDto;
import com.xforceplus.jpa.listener.TenantServiceRelListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Setter;
import org.hibernate.annotations.*;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.*;
import java.util.Date;

/**
 * @author cpp
 */
@Entity
@Setter
@Table(name = "bss_tenant_service_rel", indexes = {
        @Index(name = "idx_service_create_time", columnList = "create_time"),
        @Index(name = "idx_service_update_time", columnList = "update_time"),
        @Index(name = "idx_tenant_id", columnList = "tenant_id"),
        @Index(name = "id", columnList = "id", unique = true)
})
@NamedEntityGraphs({
        @NamedEntityGraph(name = TenantServiceRel.NAMED_ENTITY_GRAPH_DEFAULT,
                attributeNodes = {
                        @NamedAttributeNode(TenantServiceRel_.TENANT),
                        @NamedAttributeNode(TenantServiceRel_.SERVICE_PACKAGE)
                }
        )})
@DynamicInsert
@DynamicUpdate
@EntityListeners({TenantServiceRelListener.class})
public class TenantServiceRel extends TenantServicePackageDto {
    public static final String NAMED_ENTITY_GRAPH_DEFAULT = "tenantServiceRel.graph";

    @Override
    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    @Column(name = "id", nullable = false)
    public Long getId() {
        return id;
    }

    @Override
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return tenantId;
    }


    @Override
    @Column(name = "service_package_id", nullable = false)
    public Long getServicePackageId() {
        return servicePackageId;
    }

    @Override
    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }

    @Override
    @Column(name = "deleted")
    public Integer getDeleted() {
        return deleted;
    }

    @Override
    @Column(name = "create_user_id", updatable = false, length = 50)
    public String getCreaterId() {
        return createrId;
    }


    @Override
    @Column(name = "create_user_name", updatable = false, length = 50)
    public String getCreaterName() {
        return createrName;
    }


    @Override
    @Column(name = "create_time", updatable = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCreateTime() {
        return createTime;
    }


    @Override
    @Column(name = "update_user_id", length = 50)
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    @Column(name = "update_user_name", length = 50)
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    @Column(name = "update_time")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    @Column(name = "comments")
    public String getComments() {
        return comments;
    }

    @JsonView({View.Info.class})
    private ServicePackage servicePackage;

    @JsonView({View.Info.class})
    private Tenant tenant;

    @JsonIgnore
    private Long resourcesetId;

    @JsonView({View.Info.class})
    private String servicePackageName;

    @JsonView({View.Info.class})
    private String servicePackageCode;

    @JsonIgnore
    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "tenant_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    @JsonIgnore
    @LazyToOne(LazyToOneOption.NO_PROXY)
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "service_package_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public ServicePackage getServicePackage() {
        return servicePackage;
    }

    public void setServicePackage(ServicePackage servicePackage) {
        this.servicePackage = servicePackage;
    }

    @Transient
    @Override
    public String getTenantName() {
        return tenantName;
    }

    @Transient
    public String getServicePackageName() {
        return servicePackageName;
    }

    @Transient
    public String getServicePackageCode() {
        return servicePackageCode;
    }

    @Transient
    @Override
    public String getTenantCode() {
        return tenantCode;
    }

    @Transient
    public Long getResourcesetId(){
        return this.resourcesetId;
    }

}