package com.xforceplus.jpa.listener;


import com.xforceplus.domain.constants.ErrorMessage;
import com.xforceplus.domain.exception.InvalidDataException;
import com.xforceplus.domain.response.code.Rep;
import com.xforceplus.entity.CompanyApply;
import io.geewit.utils.uuid.UUIDUtils;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 公司自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class CompanyApplyListener implements OperatorListener<CompanyApply> {
    @PrePersist
    public void prePersist(CompanyApply entity) {
        if (StringUtils.isBlank(entity.getCompanyCode())) {
            entity.setCompanyCode(UUIDUtils.randomUUID());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank(entity.getTaxNum())) {
            throw new InvalidDataException(Rep.CommonCode.PARAM_FORMAT_WRONG, ErrorMessage.COMPANY_TAX_NUMBER_CANNOT_BE_NULL);
        }
        if (StringUtils.isBlank(entity.getCompanyName())) {
            throw new InvalidDataException(Rep.CommonCode.PARAM_FORMAT_WRONG, ErrorMessage.COMPANY_NAME_CANNOT_BE_NULL);
        }
        OperatorListener.super.beforeInsert(entity);
        OperatorListener.super.beforeUpdate(entity);
    }

    @PreUpdate
    public void preUpdate(CompanyApply entity) {
        OperatorListener.super.beforeUpdate(entity);
    }
}