package com.xforceplus.jpa.listener;

import com.xforceplus.entity.CompanyServiceRel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;
import java.util.Date;

/**
 * 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2019-10-29
 */
public class CompanyServiceRelListener {
    @PrePersist
    public void prePersist(CompanyServiceRel entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreateId(String.valueOf(authorizedUser.getId()));
            entity.setUpdaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setCreateUserName(authorizedUser.getOperaterName());
                entity.setUpdaterName(authorizedUser.getOperaterName());
            } else {
                entity.setCreateUserName(StringUtils.EMPTY);
                entity.setUpdaterName(StringUtils.EMPTY);
            }
            Date now = Calendar.getInstance().getTime();
            entity.setCreateTime(now);
            entity.setUpdateTime(now);
        }
    }

    @PreUpdate
    public void preUpdate(CompanyServiceRel entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setUpdaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setUpdaterName(authorizedUser.getOperaterName());
            } else {
                entity.setUpdaterName(StringUtils.EMPTY);
            }
        }
    }
}