package com.xforceplus.jpa.listener;

import com.xforceplus.tenant.security.core.context.ClientInfoHolder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.domain.ICreater;
import org.apache.commons.lang3.StringUtils;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public interface CreaterListener<U extends ICreater> {
    default void beforeInsert(U entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreaterId(String.valueOf(authorizedUser.getId()));
            if (authorizedUser.getOperaterName() != null) {
                entity.setCreaterName(authorizedUser.getOperaterName());
            } else {
                entity.setCreaterName(StringUtils.EMPTY);
            }
        } else {
            //client token创建人和更新人设置为clientId
            String clientId = ClientInfoHolder.get();
            if (StringUtils.isNotEmpty(clientId)) {
                entity.setCreaterName(clientId);
                entity.setCreaterId(clientId);
            }
        }
    }
}
