package com.xforceplus.jpa.listener;


import com.xforceplus.domain.ExtensionDto;

import java.util.Calendar;


/**
 * 公司自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class ExtensionListener<E extends ExtensionDto> {
    public void preInsert(E entity) {
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        entity.setCreateTime(Calendar.getInstance().getTime());
    }

    public void preModify(E entity) {
        entity.setUpdateTime(Calendar.getInstance().getTime());
    }
}