package com.xforceplus.jpa.listener;


import com.xforceplus.entity.OrgType;
import com.xforceplus.entity.OrgType_;
import com.xforceplus.event.dto.OrgTypeCodeChanged;
import com.xforceplus.event.dto.OrgTypeNameChanged;
import com.xforceplus.event.model.EntityPreSaveEvent;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;


/**
 * @author duanhy
 */
public class OrgTypeListener implements OperatorListener<OrgType>, ApplicationEventPublisherAware {

    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(OrgType entity) {

        //region 发送校验事件
        EntityPreSaveEvent<OrgTypeCodeChanged> codeValidationEvent =
                new EntityPreSaveEvent<>(RevisionMetadata.RevisionType.INSERT, OrgTypeCodeChanged.builder().entity(entity).build());
        applicationEventPublisher.publishEvent(codeValidationEvent);
        EntityPreSaveEvent<OrgTypeNameChanged> nameValidationEvent =
                new EntityPreSaveEvent<>(RevisionMetadata.RevisionType.INSERT, OrgTypeNameChanged.builder().entity(entity).build());
        applicationEventPublisher.publishEvent(nameValidationEvent);

        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (entity.getDeleted() == null) {
            entity.setDeleted(false);
        }
        Date now = Calendar.getInstance().getTime();
        if (null == entity.getUpdateTime()) {
            entity.setUpdateTime(now);
        }
        if (null == entity.getCreateTime()) {
            entity.setCreateTime(now);
        }
        OperatorListener.super.beforeInsert(entity);
        OperatorListener.super.beforeUpdate(entity);
    }

    @PreUpdate
    public void preUpdate(OrgType entity) {
        OperatorListener.super.beforeUpdate(entity);
        if (entity instanceof ManagedEntity) {
            EntityEntry entityEntry = ((ManagedEntity) entity).$$_hibernate_getEntityEntry();
            boolean codeChanged;
            boolean nameChanged;
            if (entityEntry != null) {
                codeChanged = !Objects.equals(entityEntry.getLoadedValue(OrgType_.CODE), entity.getCode());
                nameChanged = !Objects.equals(entityEntry.getLoadedValue(OrgType_.NAME), entity.getName());
            } else {
                codeChanged = entity.getCode() != null;
                nameChanged = entity.getName() != null;
            }
            if (codeChanged) {
                //region 发送校验事件
                EntityPreSaveEvent<OrgTypeCodeChanged> codeValidationEvent =
                        new EntityPreSaveEvent<>(RevisionMetadata.RevisionType.UPDATE, OrgTypeCodeChanged.builder().entity(entity).build());
                applicationEventPublisher.publishEvent(codeValidationEvent);
                //endregion
            }

            if (nameChanged) {
                //region 发送校验事件
                EntityPreSaveEvent<OrgTypeNameChanged> nameValidationEvent =
                        new EntityPreSaveEvent<>(RevisionMetadata.RevisionType.UPDATE, OrgTypeNameChanged.builder().entity(entity).build());
                applicationEventPublisher.publishEvent(nameValidationEvent);
                //endregion
            }
        }

    }
}