package com.xforceplus.jpa.listener;

import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.OrgUserRel_;
import com.xforceplus.event.model.EntityPostRemoveEvent;
import com.xforceplus.event.model.EntityPostSaveEvent;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Objects;

/**
 * @author geewit
 */
public class OrgUserRelListener implements OperatorListener<OrgUserRel>, ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(OrgUserRel entity) {
        OperatorListener.super.beforeInsert(entity);
        OperatorListener.super.beforeUpdate(entity);
    }

    @PreUpdate
    public void preUpdate(OrgUserRel entity) {
        boolean newRelType = Boolean.FALSE;
        if (entity instanceof ManagedEntity) {
            EntityEntry entityEntry = ((ManagedEntity) entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                newRelType = !Objects.equals(entityEntry.getLoadedValue(OrgUserRel_.REL_TYPE), entity.getRelType());
            } else {
                newRelType = entity.getRelType() != null;
            }
        }
        if (newRelType) {
            OperatorListener.super.beforeUpdate(entity);
        }
    }

    @PostPersist
    public void postPersist(OrgUserRel entity) {
        //region 发送事件
        EntityPostSaveEvent<OrgUserRel> entityPersistEvent = new EntityPostSaveEvent<>(RevisionMetadata.RevisionType.INSERT, entity);
        applicationEventPublisher.publishEvent(entityPersistEvent);
        //endregion
    }

    @PostRemove
    public void postRemove(OrgUserRel entity) {
        //region 发送事件
        EntityPostRemoveEvent<OrgUserRel> entityRemoveEvent = new EntityPostRemoveEvent<>(entity);
        applicationEventPublisher.publishEvent(entityRemoveEvent);
        //endregion
    }
}
