package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Resourceset;
import io.geewit.utils.uuid.UUID;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

/**
 * 资源码自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class ResourcesetListener implements OperatorListener<Resourceset> {
    @PrePersist
    public void prePersist(Resourceset entity) {
        if (StringUtils.isBlank(entity.getResourcesetCode())) {
            entity.setResourcesetCode(UUID.randomUUID().toString());
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        OperatorListener.super.beforeInsert(entity);
        OperatorListener.super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(Resourceset entity) {
        OperatorListener.super.beforeUpdate(entity);
        this.cleanRelatedEntities(entity);
    }

    private void cleanRelatedEntities(Resourceset entity) {
        entity.setResourcesetResourceRels(null);
        entity.setRoleResourcesetRels(null);
        entity.setServiceResourcesetRels(null);
    }

    @PostLoad
    public void postLoad(Resourceset entity) {
        entity.postLoad();
    }
}