package com.xforceplus.jpa.listener;

import com.xforceplus.entity.RoleOrgRel;
import com.xforceplus.entity.RoleOrgRel_;
import com.xforceplus.event.dto.RoleOrgDefaultBindUserChanged;
import com.xforceplus.event.model.EntityPostSaveEvent;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

import javax.persistence.*;
import java.util.Objects;

/**
 * @author geewit
 */
public class RoleOrgRelListener implements CreaterListener<RoleOrgRel>, ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    private final ThreadLocal<RoleOrgDefaultBindUserChanged> defaultBindUserChangedThreadLocal = new ThreadLocal<>();

    @PrePersist
    public void prePersist(RoleOrgRel entity) {
        if (entity.getDefaultBindUser() == null) {
            entity.setDefaultBindUser(Boolean.FALSE);
        }
        if (entity.getRoleId() != null && entity.getOrgId() != null && Objects.equals(entity.getDefaultBindUser(), Boolean.TRUE)) {
            RoleOrgDefaultBindUserChanged roleOrgDefaultBindUserChanged = RoleOrgDefaultBindUserChanged.builder()
                    .orgId(entity.getOrgId())
                    .roleId(entity.getRoleId())
                    .defaultBindUser(Boolean.TRUE)
                    .build();
            defaultBindUserChangedThreadLocal.set(roleOrgDefaultBindUserChanged);
        }
        CreaterListener.super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(RoleOrgRel entity) {
        if (entity instanceof ManagedEntity) {
            EntityEntry entityEntry = ((ManagedEntity) entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                Boolean preDefaultBindUser = (Boolean) entityEntry.getLoadedValue(RoleOrgRel_.DEFAULT_BIND_USER);
                boolean defaultBindUserChanged = !Objects.equals(preDefaultBindUser, entity.getDefaultBindUser());
                if (defaultBindUserChanged) {
                    RoleOrgDefaultBindUserChanged roleOrgDefaultBindUserChanged = RoleOrgDefaultBindUserChanged.builder()
                            .orgId(entity.getOrgId())
                            .roleId(entity.getRoleId())
                            .defaultBindUser(ObjectUtils.defaultIfNull(entity.getDefaultBindUser(), Boolean.FALSE))
                            .build();
                    defaultBindUserChangedThreadLocal.set(roleOrgDefaultBindUserChanged);
                }
            }
        }
    }

    @PostPersist
    public void postPersist(RoleOrgRel entity) {
        this.postSave();
    }

    @PostUpdate
    public void postUpdate(RoleOrgRel entity) {
        this.postSave();
    }

    private void postSave() {
        RoleOrgDefaultBindUserChanged defaultBindUserChanged = defaultBindUserChangedThreadLocal.get();
        if (defaultBindUserChanged != null) {
            EntityPostSaveEvent<RoleOrgDefaultBindUserChanged> defaultBindUserChangedEvent = new EntityPostSaveEvent<>(RevisionMetadata.RevisionType.UPDATE, defaultBindUserChanged);
            applicationEventPublisher.publishEvent(defaultBindUserChangedEvent);
        }
        defaultBindUserChangedThreadLocal.remove();
    }

    @PostRemove
    public void postRemove(RoleOrgRel entity) {
        if (entity.getRoleId() != null && entity.getOrgId() != null) {
            RoleOrgDefaultBindUserChanged defaultBindUserChanged = RoleOrgDefaultBindUserChanged.builder()
                    .orgId(entity.getOrgId())
                    .roleId(entity.getRoleId())
                    .defaultBindUser(Boolean.FALSE)
                    .build();
            EntityPostSaveEvent<RoleOrgDefaultBindUserChanged> defaultBindUserChangedEvent = new EntityPostSaveEvent<>(RevisionMetadata.RevisionType.DELETE, defaultBindUserChanged);
            applicationEventPublisher.publishEvent(defaultBindUserChangedEvent);
        }
    }
}