package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Tag;
import com.xforceplus.event.model.EntityPreSaveEvent;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;


/**
 * 帐号自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class TagListener implements OperatorListener<Tag>, ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(Tag entity) {
        //region 发送校验事件
        EntityPreSaveEvent<Tag> entityPreSaveEvent = new EntityPreSaveEvent<>(RevisionMetadata.RevisionType.INSERT, entity);
        applicationEventPublisher.publishEvent(entityPreSaveEvent);
        //endregion
        if (entity.getId() == null) {
            long id = SnowflakeGenerator.id(Tag.class);
            entity.setId(id);
        }
        Date now = Calendar.getInstance().getTime();
        if (null == entity.getUpdateTime()) {
            entity.setUpdateTime(now);
        }
        if (null == entity.getCreateTime()) {
            entity.setCreateTime(now);
        }
        if (Objects.isNull(entity.getTagDesc())) {
            entity.setTagDesc(StringUtils.EMPTY);
        }
        entity.setTagCode(StringUtils.isEmpty(entity.getTagCode()) ? String.valueOf(entity.getId()) : entity.getTagCode());
        entity.setDeleted(Boolean.FALSE);
        OperatorListener.super.beforeInsert(entity);
        OperatorListener.super.beforeUpdate(entity);
    }

    @PreUpdate
    public void preUpdate(Tag entity) {
        OperatorListener.super.beforeUpdate(entity);
    }
}