package com.xforceplus.jpa.listener;


import com.xforceplus.entity.TenantPolicy;
import io.geewit.utils.uuid.UUID;

import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 租户策略 自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class TenantPolicyListener implements OperatorListener<TenantPolicy> {
    @PrePersist
    public void prePersist(TenantPolicy entity) {
        if (entity.getName() == null) {
            entity.setName(UUID.randomUUID().toString());
        }
        OperatorListener.super.beforeInsert(entity);
        OperatorListener.super.beforeUpdate(entity);
        entity.setTenant(null);
    }

    @PreUpdate
    public void preUpdate(TenantPolicy entity) {
        OperatorListener.super.beforeUpdate(entity);
        entity.setTenant(null);
    }

    @PostLoad
    public void postLoad(TenantPolicy entity) {
        entity.postLoad();
    }
}