package com.xforceplus.jpa.listener;

import com.xforceplus.entity.TenantRelation;
import com.xforceplus.entity.TenantServiceRel;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

/**
 * @author cpp
 */
public class TenantServiceRelListener implements OperatorListener<TenantServiceRel> {

    @PrePersist
    public void prePersist(TenantServiceRel entity) {
        if (entity.getId() == null) {
            long id = SnowflakeGenerator.id(TenantRelation.class);
            entity.setId(id);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (entity.getDeleted() == null) {
            entity.setDeleted(0);
        }
        OperatorListener.super.beforeInsert(entity);
        OperatorListener.super.beforeUpdate(entity);
    }

    @PreUpdate
    public void preUpdate(TenantServiceRel entity) {
        OperatorListener.super.beforeUpdate(entity);
    }
}
