package com.xforceplus.jpa.listener;


import com.xforceplus.entity.UserTag;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 租户策略 自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class UserTagListener implements OperatorListener<UserTag> {
    @PrePersist
    public void prePersist(UserTag entity) {
        this.cleanRelatedEntities(entity);
        OperatorListener.super.beforeInsert(entity);
        OperatorListener.super.beforeUpdate(entity);
    }

    @PreUpdate
    public void preUpdate(UserTag entity) {
        this.cleanRelatedEntities(entity);
        OperatorListener.super.beforeUpdate(entity);
    }

    private void cleanRelatedEntities(UserTag entity) {
        entity.setUser(null);
    }
}