/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.domain.exception.InvalidDataException;
import com.xforceplus.entity.Company;
import com.xforceplus.event.dto.CompanyChanged;
import com.xforceplus.event.dto.CompanyNameChanged;
import com.xforceplus.event.model.EntityPostSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import io.geewit.utils.uuid.UUID;
import java.util.Objects;
import javax.persistence.PostLoad;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class CompanyListener
extends OperatorListener<Company>
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;
    private final ThreadLocal<CompanyNameChanged> companyNameChangedThreadLocal = new ThreadLocal();

    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(Company entity) {
        if (entity.getCompanyId() == null) {
            long id = SnowflakeGenerator.id(Company.class);
            entity.setCompanyId(id);
        }
        if (StringUtils.isEmpty((CharSequence)entity.getCompanyCode())) {
            String companyCode = UUID.randomUUID().toString();
            entity.setCompanyCode(companyCode);
        }
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank((CharSequence)entity.getTaxNum())) {
            throw new InvalidDataException("UCTSCM0003", "\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)entity.getCompanyName())) {
            throw new InvalidDataException("UCTSCM0003", "\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (entity.getEffective() == null) {
            entity.setEffective(true);
        }
        this.cleanRelatedEntities(entity);
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(Company entity) {
        if (entity.getEffective() == null) {
            entity.setEffective(true);
        }
        boolean newCompanyName = false;
        String preCompanyName = null;
        if (entity instanceof ManagedEntity) {
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                preCompanyName = (String)entityEntry.getLoadedValue("companyName");
                newCompanyName = !Objects.equals(preCompanyName, entity.getCompanyName());
            } else {
                boolean bl = newCompanyName = entity.getCompanyName() != null;
            }
        }
        if (newCompanyName) {
            CompanyNameChanged companyNameChanged = CompanyNameChanged.builder().companyId(entity.getCompanyId()).preCompanyName(preCompanyName).postCompanyName(entity.getCompanyName()).build();
            this.companyNameChangedThreadLocal.set(companyNameChanged);
        }
        this.cleanRelatedEntities(entity);
        super.beforeUpdate(entity);
    }

    @PostUpdate
    public void postUpdate(Company entity) {
        CompanyNameChanged companyNameChanged = this.companyNameChangedThreadLocal.get();
        if (companyNameChanged != null) {
            EntityPostSaveEvent<CompanyNameChanged> companyNameUpdateEvent = new EntityPostSaveEvent<CompanyNameChanged>(RevisionMetadata.RevisionType.UPDATE, companyNameChanged);
            this.applicationEventPublisher.publishEvent(companyNameUpdateEvent);
        }
        this.companyNameChangedThreadLocal.remove();
        EntityPostSaveEvent<CompanyChanged> entityUpdateEvent = new EntityPostSaveEvent<CompanyChanged>(RevisionMetadata.RevisionType.UPDATE, CompanyChanged.builder().company(entity).build());
        this.applicationEventPublisher.publishEvent(entityUpdateEvent);
    }

    private void cleanRelatedEntities(Company entity) {
        entity.setTenantRels(null);
        entity.setHostOrgs(null);
        entity.setOrgs(null);
    }

    @PostLoad
    public void postLoad(Company entity) {
        entity.postLoad();
    }
}

