/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.OrgType;
import com.xforceplus.event.dto.OrgTypeCodeChanged;
import com.xforceplus.event.dto.OrgTypeNameChanged;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class OrgTypeListener
extends OperatorListener<OrgType>
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(OrgType entity) {
        EntityPreSaveEvent<OrgTypeCodeChanged> codeValidationEvent = new EntityPreSaveEvent<OrgTypeCodeChanged>(RevisionMetadata.RevisionType.INSERT, OrgTypeCodeChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(codeValidationEvent);
        EntityPreSaveEvent<OrgTypeNameChanged> nameValidationEvent = new EntityPreSaveEvent<OrgTypeNameChanged>(RevisionMetadata.RevisionType.INSERT, OrgTypeNameChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(nameValidationEvent);
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (entity.getDeleted() == null) {
            entity.setDeleted(false);
        }
        Date now = Calendar.getInstance().getTime();
        if (null == entity.getUpdateTime()) {
            entity.setUpdateTime(now);
        }
        if (null == entity.getCreateTime()) {
            entity.setCreateTime(now);
        }
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(OrgType entity) {
        super.beforeUpdate(entity);
        if (entity instanceof ManagedEntity) {
            boolean nameChanged;
            boolean codeChanged;
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                codeChanged = !Objects.equals(entityEntry.getLoadedValue("code"), entity.getCode());
                nameChanged = !Objects.equals(entityEntry.getLoadedValue("name"), entity.getName());
            } else {
                codeChanged = entity.getCode() != null;
                boolean bl = nameChanged = entity.getName() != null;
            }
            if (codeChanged) {
                EntityPreSaveEvent<OrgTypeCodeChanged> codeValidationEvent = new EntityPreSaveEvent<OrgTypeCodeChanged>(RevisionMetadata.RevisionType.UPDATE, OrgTypeCodeChanged.builder().entity(entity).build());
                this.applicationEventPublisher.publishEvent(codeValidationEvent);
            }
            if (nameChanged) {
                EntityPreSaveEvent<OrgTypeNameChanged> nameValidationEvent = new EntityPreSaveEvent<OrgTypeNameChanged>(RevisionMetadata.RevisionType.UPDATE, OrgTypeNameChanged.builder().entity(entity).build());
                this.applicationEventPublisher.publishEvent(nameValidationEvent);
            }
        }
    }
}

