/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Role;
import com.xforceplus.event.dto.RoleCodeChanged;
import com.xforceplus.event.dto.RoleNameChanged;
import com.xforceplus.event.model.EntityPostRemoveEvent;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import java.util.Objects;
import javax.persistence.PostRemove;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class RoleListener
extends OperatorListener<Role>
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(Role entity) {
        EntityPreSaveEvent<RoleCodeChanged> codeValidationEvent = new EntityPreSaveEvent<RoleCodeChanged>(RevisionMetadata.RevisionType.INSERT, RoleCodeChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(codeValidationEvent);
        EntityPreSaveEvent<RoleNameChanged> nameValidationEvent = new EntityPreSaveEvent<RoleNameChanged>(RevisionMetadata.RevisionType.INSERT, RoleNameChanged.builder().entity(entity).build());
        this.applicationEventPublisher.publishEvent(nameValidationEvent);
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank((CharSequence)entity.getRoleDesc())) {
            entity.setRoleDesc("");
        }
        if (entity.getType() == null) {
            entity.setType(0);
        }
        super.beforeInsert(entity);
        this.cleanRelatedEntities(entity);
    }

    @PreUpdate
    public void preUpdate(Role entity) {
        if (entity instanceof ManagedEntity) {
            boolean nameChanged;
            boolean codeChanged;
            EntityEntry entityEntry = ((ManagedEntity)entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                codeChanged = !Objects.equals(entityEntry.getLoadedValue("code"), entity.getCode());
                nameChanged = !Objects.equals(entityEntry.getLoadedValue("name"), entity.getName());
            } else {
                codeChanged = entity.getCode() != null;
                boolean bl = nameChanged = entity.getName() != null;
            }
            if (codeChanged) {
                EntityPreSaveEvent<RoleCodeChanged> codeValidationEvent = new EntityPreSaveEvent<RoleCodeChanged>(RevisionMetadata.RevisionType.UPDATE, RoleCodeChanged.builder().entity(entity).build());
                this.applicationEventPublisher.publishEvent(codeValidationEvent);
            }
            if (nameChanged) {
                EntityPreSaveEvent<RoleNameChanged> nameValidationEvent = new EntityPreSaveEvent<RoleNameChanged>(RevisionMetadata.RevisionType.UPDATE, RoleNameChanged.builder().entity(entity).build());
                this.applicationEventPublisher.publishEvent(nameValidationEvent);
            }
        }
        if (StringUtils.isBlank((CharSequence)entity.getRoleDesc())) {
            entity.setRoleDesc(entity.getName());
        }
        super.beforeUpdate(entity);
    }

    @PostRemove
    public void postRemove(Role entity) {
        EntityPostRemoveEvent<Role> entityRemoveEvent = new EntityPostRemoveEvent<Role>(entity);
        this.applicationEventPublisher.publishEvent(entityRemoveEvent);
    }

    private void cleanRelatedEntities(Role entity) {
        entity.setRoleResourcesetRels(null);
        entity.setRoleUserRels(null);
    }
}

