/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Tag;
import com.xforceplus.event.model.EntityPreSaveEvent;
import com.xforceplus.jpa.listener.OperatorListener;
import io.geewit.data.jpa.essential.id.SnowflakeGenerator;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.persistence.PrePersist;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.history.RevisionMetadata;

public class TagListener
extends OperatorListener<Tag>
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @PrePersist
    public void prePersist(Tag entity) {
        EntityPreSaveEvent<Tag> entityPreSaveEvent = new EntityPreSaveEvent<Tag>(RevisionMetadata.RevisionType.INSERT, entity);
        this.applicationEventPublisher.publishEvent(entityPreSaveEvent);
        if (entity.getId() == null) {
            long id = SnowflakeGenerator.id(Tag.class);
            entity.setId(id);
        }
        Date now = Calendar.getInstance().getTime();
        if (null == entity.getUpdateTime()) {
            entity.setUpdateTime(now);
        }
        if (null == entity.getCreateTime()) {
            entity.setCreateTime(now);
        }
        if (Objects.isNull(entity.getTagDesc())) {
            entity.setTagDesc("");
        }
        entity.setTagCode(StringUtils.isEmpty((CharSequence)entity.getTagCode()) ? String.valueOf(entity.getId()) : entity.getTagCode());
        entity.setDeleted(Boolean.FALSE);
        super.beforeInsert(entity);
    }
}

