package com.xforceplus.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * 版权：    上海云砺信息科技有限公司
 * @author  duanhy
 * 创建时间: 2020/12/3 20:40
 * 功能描述:
 * 修改历史:
 */
public class StringHelp {

    public static String safeToString(Object obj) {
        if (obj == null) {
            return "";
        } else if (obj instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return formatter.format(obj);
        } else {
            return obj.toString();
        }
    }

    /**
     * key在str出现的次数
     *
     * @param str
     * @param key
     * @return
     */
    public static int getCount(String str, String key) {
        if (str == null || key == null || "".equals(str.trim()) || "".equals(key.trim())) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(key, index)) != -1) {
            index = index + key.length();
            count++;
        }
        return count;
    }

    /**
     * parentIds 转 set   1#2/
     * @param parentIds
     * @return
     */
    public static Set<Long> findNodeIdsByParentIds(String parentIds) {
        String[] parentArr = parentIds.split("\\#|\\-|\\||/|%");
        Set<Long> parentIdSet = new HashSet<>();
        for (String s : parentArr) {
            parentIdSet.add(Long.parseLong(s));
        }
        return parentIdSet;
    }
}
