package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ServicePackageDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


@ApiModel("公司服务包")
public class CompanyPackage {
    public CompanyPackage() {
    }

    public CompanyPackage(String tenantName, String companyName, Integer status) {
        this.tenantName = tenantName;
        this.companyName = companyName;
        this.status = status;
    }

    public CompanyPackage(Long tenantId, String tenantName, Long companyId, String companyName) {
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.companyId = companyId;
        this.companyName = companyName;
    }

    @ApiModelProperty(value = "租户id")
    @JsonView(View.class)
    protected Long tenantId;

    @ApiModelProperty(value = "租户名称")
    @JsonView(View.class)
    protected String tenantName;

    @ApiModelProperty(value = "公司id")
    @JsonView(View.class)
    protected Long companyId;

    @ApiModelProperty(value = "公司名称")
    @JsonView(View.class)
    protected String companyName;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "服务包集合")
    @JsonView(View.Info.class)
    protected List<ServicePackageDto> packages;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<ServicePackageDto> getPackages() {
        return packages;
    }

    public void setPackages(List<ServicePackageDto> packages) {
        this.packages = packages;
    }
}
