package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenantsecurity.domain.IOrg;
import com.xforceplus.tenantsecurity.domain.OrgType;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel(value = "组织")
public class OrgDto<O extends OrgDto<O>> implements IOrg {
    @ApiModelProperty("组织id")
    @JsonView(View.class)
    protected Long orgId;

    @ApiModelProperty("租户id")
    @JsonView(View.class)
    protected Long tenantId;

    @ApiModelProperty("公司id")
    @JsonView(View.class)
    protected Long companyId;

    @ApiModelProperty("组织代码")
    @JsonView(View.class)
    protected String orgCode;

    @ApiModelProperty("组织名称")
    @JsonView(View.class)
    protected String orgName;

    @ApiModelProperty("快速查询索引")
    @JsonView(View.class)
    protected String parentIds;

    @ApiModelProperty("上级组织id")
    @JsonView(View.class)
    protected Long parentId;

    @ApiModelProperty("组织类型")
    @JsonView(View.class)
    protected OrgType orgType;

    @ApiModelProperty("组织描述")
    @JsonView(View.class)
    protected String orgDesc;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty("上级组织")
    @JsonView(View.Tree.class)
    @JsonBackReference("parent-children")
    protected O parent;

    @ApiModelProperty("下级组织集合")
    @JsonView(View.Tree.class)
    @JsonManagedReference("parent-children")
    protected List<O> children;

    @ApiModelProperty("公司代码集合")
    @JsonView(View.Info.class)
    protected List<String> companyNos;

    @Min(value = 1)
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @Min(value = 1)
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @NotNull
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getParentIds() {
        return parentIds;
    }

    public void setParentIds(String parentIds) {
        this.parentIds = parentIds;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public OrgType getOrgType() {
        return orgType;
    }

    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }

    public String getOrgDesc() {
        return orgDesc;
    }

    public void setOrgDesc(String orgDesc) {
        this.orgDesc = orgDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<String> getCompanyNos() {
        return companyNos;
    }

    public void setCompanyNos(List<String> companyNos) {
        this.companyNos = companyNos;
    }

    public O getParent() {
        return parent;
    }

    public void setParent(O parent) {
        this.parent = parent;
    }

    public List<O> getChildren() {
        return children;
    }

    public void setChildren(List<O> children) {
        this.children = children;
    }
}
