package com.xforceplus.domain.user;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ResourceDto;
import com.xforceplus.domain.resource.ResourcesetDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

@ApiModel(value = "角色")
public class RoleDto<RS extends ResourcesetDto<RE>, RE extends ResourceDto> {
    @ApiModelProperty(value = "角色id")
    @JsonView(View.class)
    protected Long roleId;

    @ApiModelProperty(value = "角色代码")
    @JsonView(View.class)
    protected String roleCode;

    @ApiModelProperty(value = "租户id")
    @JsonView(View.class)
    protected Long tenantId;

    @ApiModelProperty(value = "角色名称")
    @JsonView(View.class)
    protected String roleName;

    @ApiModelProperty(value = "角色描述")
    @JsonView(View.class)
    protected String roleDesc;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "关联功能集集合")
    @JsonView(View.Info.class)
    protected Set<RS> resourcesets;

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleDesc() {
        return roleDesc;
    }

    public void setRoleDesc(String roleDesc) {
        this.roleDesc = roleDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Set<RS> getResourcesets() {
        return resourcesets;
    }

    public void setResourcesets(Set<RS> resourcesets) {
        this.resourcesets = resourcesets;
    }
}
