package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "公司")
public class CompanyDto {
    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "公司id")
    protected Long companyId;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "企业编码")
    protected String companyCode;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "企业名称")
    protected String companyName;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "税号")
    protected String taxNum;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "公司经营所在省份")
    protected String locationArea;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "公司经营所在市区")
    protected String locationCity;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "公司经营详细地址")
    protected String locationAddr;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "公司经营电话")
    protected String companyPhone;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "营业期限开始时间")
    protected Date businessStartTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "营业期限结束时间")
    protected Date businessEndTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "营业时间是否长期")
    protected Integer businessTimeLong;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业经营范围")
    protected String businessScope;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业Logo")
    protected String companyLogo;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "营业执照影像")
    protected String businessLicense;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "平台管理人身份", notes = "0:法定代表人, 1:代理人")
    protected Integer platManagerStatus;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人归属地")
    protected String managerLocation;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人姓名")
    protected String managerName;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件类型  1-身份证")
    protected String managerCardType;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人身份证")
    protected String managerIdCard;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人联系方式")
    protected String managerPhone;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件开始时间")
    protected Date managerIdCardStartTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件结束时间")
    protected Date managerIdCardEndTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人身份证长期")
    protected Integer managerIdCardTimeLong;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件正面照")
    protected String managerIdCardFrontPhoto;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "法人证件背面照")
    protected String managerIdCardBackPhoto;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "开户行名称")
    protected String bankName;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "开户银行支行名称")
    protected String bankBranchName;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "对公银行账户")
    protected String bankNo;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "银行所在省份")
    protected String bankArea;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "银行所在市区")
    protected String bankCity;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "注销/启用原因")
    protected String operateReason;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "传统认证管理状态", notes = "1:开启；0:关闭")
    protected Integer traditionAuthenFlag;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "查验服务状态", notes = "1:开启；0:关闭")
    protected Integer inspectionServiceFlag;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "极速查验通道状态", notes = "1:开启；0:关闭")
    protected Integer speedInspectionChannelFlag;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    protected Integer status;

    @JsonView({View.List.class, View.Page.class})
    @ApiModelProperty(value = "增值税普通发票限额")
    protected BigDecimal cquota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "增值税专用发票限额")
    protected BigDecimal squota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "增值税电子普通发票限额")
    protected BigDecimal ceQuota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "增值税普通发票-卷票限额")
    protected BigDecimal juQuota;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业注册省份")
    protected String registLocationArea;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业注册城市")
    protected String registLocationCity;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "企业注册详细地址")
    protected String registLocationAddr;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "纳税人资质类型 1:一般增值税纳税人 2:小规模纳税人")
    protected Integer taxpayerQualificationType;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "纳税人资质证书")
    protected String taxpayerQualification;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人姓名")
    protected String proxyManagerName;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证据类型  1-身份证")
    protected String proxyManagerCardType;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人身份证")
    protected String proxyManagerIdCard;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人联系方式")
    protected String proxyManagerPhone;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证件开始时间")
    protected Date proxyManagerIdCardStartTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证件结束时间")
    protected Date proxyManagerIdCardEndTime;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人身份证长期")
    protected Integer proxyManagerIdCardTimeLong;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证件正面照")
    protected String proxyManagerIdCardFrontPhoto;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "代理人证件背面照")
    protected String proxyManagerIdCardBackPhoto;

    @JsonView({View.Info.class})
    @ApiModelProperty(value = "创建时间")
    protected Date createTime;

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    public String getLocationArea() {
        return locationArea;
    }

    public void setLocationArea(String locationArea) {
        this.locationArea = locationArea;
    }

    public String getLocationCity() {
        return locationCity;
    }

    public void setLocationCity(String locationCity) {
        this.locationCity = locationCity;
    }

    public String getLocationAddr() {
        return locationAddr;
    }

    public void setLocationAddr(String locationAddr) {
        this.locationAddr = locationAddr;
    }

    public String getCompanyPhone() {
        return companyPhone;
    }

    public void setCompanyPhone(String companyPhone) {
        this.companyPhone = companyPhone;
    }

    public Date getBusinessStartTime() {
        return businessStartTime;
    }

    public void setBusinessStartTime(Date businessStartTime) {
        this.businessStartTime = businessStartTime;
    }

    public Date getBusinessEndTime() {
        return businessEndTime;
    }

    public void setBusinessEndTime(Date businessEndTime) {
        this.businessEndTime = businessEndTime;
    }

    public Integer getBusinessTimeLong() {
        return businessTimeLong;
    }

    public void setBusinessTimeLong(Integer businessTimeLong) {
        this.businessTimeLong = businessTimeLong;
    }

    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope;
    }

    public String getCompanyLogo() {
        return companyLogo;
    }

    public void setCompanyLogo(String companyLogo) {
        this.companyLogo = companyLogo;
    }

    public String getBusinessLicense() {
        return businessLicense;
    }

    public void setBusinessLicense(String businessLicense) {
        this.businessLicense = businessLicense;
    }

    public Integer getPlatManagerStatus() {
        return platManagerStatus;
    }

    public void setPlatManagerStatus(Integer platManagerStatus) {
        this.platManagerStatus = platManagerStatus;
    }

    public String getManagerLocation() {
        return managerLocation;
    }

    public void setManagerLocation(String managerLocation) {
        this.managerLocation = managerLocation;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public String getManagerCardType() {
        return managerCardType;
    }

    public void setManagerCardType(String managerCardType) {
        this.managerCardType = managerCardType;
    }

    public String getManagerIdCard() {
        return managerIdCard;
    }

    public void setManagerIdCard(String managerIdCard) {
        this.managerIdCard = managerIdCard;
    }

    public String getManagerPhone() {
        return managerPhone;
    }

    public void setManagerPhone(String managerPhone) {
        this.managerPhone = managerPhone;
    }

    public Date getManagerIdCardStartTime() {
        return managerIdCardStartTime;
    }

    public void setManagerIdCardStartTime(Date managerIdCardStartTime) {
        this.managerIdCardStartTime = managerIdCardStartTime;
    }

    public Date getManagerIdCardEndTime() {
        return managerIdCardEndTime;
    }

    public void setManagerIdCardEndTime(Date managerIdCardEndTime) {
        this.managerIdCardEndTime = managerIdCardEndTime;
    }

    public Integer getManagerIdCardTimeLong() {
        return managerIdCardTimeLong;
    }

    public void setManagerIdCardTimeLong(Integer managerIdCardTimeLong) {
        this.managerIdCardTimeLong = managerIdCardTimeLong;
    }

    public String getManagerIdCardFrontPhoto() {
        return managerIdCardFrontPhoto;
    }

    public void setManagerIdCardFrontPhoto(String managerIdCardFrontPhoto) {
        this.managerIdCardFrontPhoto = managerIdCardFrontPhoto;
    }

    public String getManagerIdCardBackPhoto() {
        return managerIdCardBackPhoto;
    }

    public void setManagerIdCardBackPhoto(String managerIdCardBackPhoto) {
        this.managerIdCardBackPhoto = managerIdCardBackPhoto;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankBranchName() {
        return bankBranchName;
    }

    public void setBankBranchName(String bankBranchName) {
        this.bankBranchName = bankBranchName;
    }

    public String getBankNo() {
        return bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public String getBankArea() {
        return bankArea;
    }

    public void setBankArea(String bankArea) {
        this.bankArea = bankArea;
    }

    public String getBankCity() {
        return bankCity;
    }

    public void setBankCity(String bankCity) {
        this.bankCity = bankCity;
    }

    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public Integer getTraditionAuthenFlag() {
        return traditionAuthenFlag;
    }

    public void setTraditionAuthenFlag(Integer traditionAuthenFlag) {
        this.traditionAuthenFlag = traditionAuthenFlag;
    }

    public Integer getInspectionServiceFlag() {
        return inspectionServiceFlag;
    }

    public void setInspectionServiceFlag(Integer inspectionServiceFlag) {
        this.inspectionServiceFlag = inspectionServiceFlag;
    }

    public Integer getSpeedInspectionChannelFlag() {
        return speedInspectionChannelFlag;
    }

    public void setSpeedInspectionChannelFlag(Integer speedInspectionChannelFlag) {
        this.speedInspectionChannelFlag = speedInspectionChannelFlag;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public BigDecimal getCquota() {
        return cquota;
    }

    public void setCquota(BigDecimal cquota) {
        this.cquota = cquota;
    }

    public BigDecimal getSquota() {
        return squota;
    }

    public void setSquota(BigDecimal squota) {
        this.squota = squota;
    }

    public BigDecimal getCeQuota() {
        return ceQuota;
    }

    public void setCeQuota(BigDecimal ceQuota) {
        this.ceQuota = ceQuota;
    }

    public BigDecimal getJuQuota() {
        return juQuota;
    }

    public void setJuQuota(BigDecimal juQuota) {
        this.juQuota = juQuota;
    }

    public String getRegistLocationArea() {
        return registLocationArea;
    }

    public void setRegistLocationArea(String registLocationArea) {
        this.registLocationArea = registLocationArea;
    }

    public String getRegistLocationCity() {
        return registLocationCity;
    }

    public void setRegistLocationCity(String registLocationCity) {
        this.registLocationCity = registLocationCity;
    }

    public String getRegistLocationAddr() {
        return registLocationAddr;
    }

    public void setRegistLocationAddr(String registLocationAddr) {
        this.registLocationAddr = registLocationAddr;
    }

    public Integer getTaxpayerQualificationType() {
        return taxpayerQualificationType;
    }

    public void setTaxpayerQualificationType(Integer taxpayerQualificationType) {
        this.taxpayerQualificationType = taxpayerQualificationType;
    }

    public String getTaxpayerQualification() {
        return taxpayerQualification;
    }

    public void setTaxpayerQualification(String taxpayerQualification) {
        this.taxpayerQualification = taxpayerQualification;
    }

    public String getProxyManagerName() {
        return proxyManagerName;
    }

    public void setProxyManagerName(String proxyManagerName) {
        this.proxyManagerName = proxyManagerName;
    }

    public String getProxyManagerCardType() {
        return proxyManagerCardType;
    }

    public void setProxyManagerCardType(String proxyManagerCardType) {
        this.proxyManagerCardType = proxyManagerCardType;
    }

    public String getProxyManagerIdCard() {
        return proxyManagerIdCard;
    }

    public void setProxyManagerIdCard(String proxyManagerIdCard) {
        this.proxyManagerIdCard = proxyManagerIdCard;
    }

    public String getProxyManagerPhone() {
        return proxyManagerPhone;
    }

    public void setProxyManagerPhone(String proxyManagerPhone) {
        this.proxyManagerPhone = proxyManagerPhone;
    }

    public Date getProxyManagerIdCardStartTime() {
        return proxyManagerIdCardStartTime;
    }

    public void setProxyManagerIdCardStartTime(Date proxyManagerIdCardStartTime) {
        this.proxyManagerIdCardStartTime = proxyManagerIdCardStartTime;
    }

    public Date getProxyManagerIdCardEndTime() {
        return proxyManagerIdCardEndTime;
    }

    public void setProxyManagerIdCardEndTime(Date proxyManagerIdCardEndTime) {
        this.proxyManagerIdCardEndTime = proxyManagerIdCardEndTime;
    }

    public Integer getProxyManagerIdCardTimeLong() {
        return proxyManagerIdCardTimeLong;
    }

    public void setProxyManagerIdCardTimeLong(Integer proxyManagerIdCardTimeLong) {
        this.proxyManagerIdCardTimeLong = proxyManagerIdCardTimeLong;
    }

    public String getProxyManagerIdCardFrontPhoto() {
        return proxyManagerIdCardFrontPhoto;
    }

    public void setProxyManagerIdCardFrontPhoto(String proxyManagerIdCardFrontPhoto) {
        this.proxyManagerIdCardFrontPhoto = proxyManagerIdCardFrontPhoto;
    }

    public String getProxyManagerIdCardBackPhoto() {
        return proxyManagerIdCardBackPhoto;
    }

    public void setProxyManagerIdCardBackPhoto(String proxyManagerIdCardBackPhoto) {
        this.proxyManagerIdCardBackPhoto = proxyManagerIdCardBackPhoto;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
