package com.xforceplus.domain.company;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


@ApiModel("公司服务包")
public class CompanyPackage {
    public CompanyPackage() {
    }

    public CompanyPackage(String servicePackageName, String companyName, Integer status) {
        this.servicePackageName = servicePackageName;
        this.companyName = companyName;
        this.status = status;
    }

    public CompanyPackage(Long tenantId, String tenantName, Long companyId, String companyName, Integer status) {
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.companyId = companyId;
        this.companyName = companyName;
        this.status = status;
    }

    @ApiModelProperty(value = "租户id")
    protected Long tenantId;

    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @ApiModelProperty(value = "公司id")
    protected Long companyId;

    @ApiModelProperty(value = "公司名称")
    protected String companyName;

    @ApiModelProperty(value = "服务包名称")
    protected String servicePackageName;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    protected Integer status;

    @ApiModelProperty(value = "服务包名称集合")
    protected List<String> packageNames;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getServicePackageName() {
        return servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<String> getPackageNames() {
        return packageNames;
    }

    public void setPackageNames(List<String> packageNames) {
        this.packageNames = packageNames;
    }
}
