package com.xforceplus.domain.resource;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.bind.annotation.RequestMethod;

@ApiModel("服务Api接口")
public class ServiceApiDto {
    @ApiModelProperty(value = "服务Api接口id")
    protected Long serviceApiId;

    @ApiModelProperty(value = "服务Api接口类名路径")
    protected String serviceApiPath;

    @ApiModelProperty(value = "请求url")
    protected String serviceApiUrl;

    @ApiModelProperty(value = "Http请求方法")
    protected RequestMethod requestMethod;

    @ApiModelProperty(value = "appid")
    protected Long appId;

    @ApiModelProperty(value = "路由id")
    protected Long routeId;

    @ApiModelProperty(value = "跳过鉴权", notes = "1:跳过, 0:不跳过")
    protected Integer isSkipAuth;

    @ApiModelProperty(value = "跳过认证", notes = "1:跳过, 0:不跳过")
    protected Integer isSkipCheck;

    @ApiModelProperty(value = "服务Api接口名称")
    protected String serviceApiName;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    protected Integer status;

    public Long getServiceApiId() {
        return serviceApiId;
    }

    public void setServiceApiId(Long serviceApiId) {
        this.serviceApiId = serviceApiId;
    }

    public String getServiceApiPath() {
        return serviceApiPath;
    }

    public void setServiceApiPath(String serviceApiPath) {
        this.serviceApiPath = serviceApiPath;
    }

    public String getServiceApiUrl() {
        return serviceApiUrl;
    }

    public void setServiceApiUrl(String serviceApiUrl) {
        this.serviceApiUrl = serviceApiUrl;
    }

    public RequestMethod getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getRouteId() {
        return routeId;
    }

    public void setRouteId(Long routeId) {
        this.routeId = routeId;
    }

    public Integer getIsSkipAuth() {
        return isSkipAuth;
    }

    public void setIsSkipAuth(Integer isSkipAuth) {
        this.isSkipAuth = isSkipAuth;
    }

    public Integer getIsSkipCheck() {
        return isSkipCheck;
    }

    public void setIsSkipCheck(Integer isSkipCheck) {
        this.isSkipCheck = isSkipCheck;
    }

    public String getServiceApiName() {
        return serviceApiName;
    }

    public void setServiceApiName(String serviceApiName) {
        this.serviceApiName = serviceApiName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

}
