package com.xforceplus.domain.settle;

import com.fasterxml.jackson.core.type.TypeReference;
import io.geewit.web.utils.JsonUtils;

import javax.persistence.Transient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettleTemplateDto<A extends SettleTemplateAttributeDto> {
    protected Long templateId;
    protected String templateName;
    protected String rawProperties;

    protected List<A> attributes;

    protected List<String> serviceCodes;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getRawProperties() {
        return rawProperties;
    }

    public void setRawProperties(String rawProperties) {
        this.rawProperties = rawProperties;
    }

    public List<A> getAttributes() {
        return attributes;
    }

    public void setAttributes(List<A> attributes) {
        this.attributes = attributes;
    }

    public List<String> getServiceCodes() {
        return serviceCodes;
    }

    public void setServiceCodes(List<String> serviceCodes) {
        this.serviceCodes = serviceCodes;
    }

    @Transient
    public Map<String, String> geProperties(Map<String, String> flowProperties) {
        if (flowProperties == null) {
            flowProperties = new HashMap<>();
        }
        if (this.rawProperties != null) {
            try {
                Map<String, String> properties = JsonUtils.fromJson(this.rawProperties, new TypeReference<Map<String, String>>() {
                });
                flowProperties.putAll(properties);
            } catch (Exception ignore) {
            }
        }

        return flowProperties;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SettleTemplateDto that = (SettleTemplateDto) o;
        return Objects.equals(templateId, that.templateId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(templateId);
    }

    @Override
    public String toString() {
        return "SettleTemplateDto{" +
                "templateId=" + templateId +
                ", templateName='" + templateName + '\'' +
                ", rawProperties='" + rawProperties + '\'' +
                '}';
    }
}
