package com.xforceplus.domain.user;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(value = "用户")
public class UserRaw {
    @ApiModelProperty("用户id")
    @JsonView(View.class)
    protected Long id;

    @ApiModelProperty("租户id")
    @JsonView(View.class)
    protected Long tenantId;

    @ApiModelProperty("账户id")
    @JsonView(View.class)
    protected Long accountId;

    @ApiModelProperty("用户代码")
    @JsonView(View.class)
    protected String userCode;

    @ApiModelProperty(value = "用户编码", notes = "预留给业务系统使用")
    @JsonView(View.class)
    protected String userNumber;

    @ApiModelProperty(value = "用户名称", notes = "预留给业务系统使用")
    @JsonView(View.class)
    protected String userName;

    @JsonView(View.class)
    protected String userPhone;

    @ApiModelProperty(value = "性别")
    @JsonView(View.class)
    protected Integer userSex;

    @JsonView(View.class)
    protected String userEmailAddr;

    @JsonView(View.class)
    protected String userIdCard;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08")
    @JsonView(View.class)
    protected Date userPeriodTime;

    @JsonView(View.class)
    protected String userWorkTel;

    @JsonView(View.class)
    protected Integer activeStatus;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(View.class)
    protected String contactAddr;

    @JsonView(View.class)
    protected String businessExtensionAttribute;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    public Integer getUserSex() {
        return userSex;
    }

    public void setUserSex(Integer userSex) {
        this.userSex = userSex;
    }

    public String getUserEmailAddr() {
        return userEmailAddr;
    }

    public void setUserEmailAddr(String userEmailAddr) {
        this.userEmailAddr = userEmailAddr;
    }

    public String getUserIdCard() {
        return userIdCard;
    }

    public void setUserIdCard(String userIdCard) {
        this.userIdCard = userIdCard;
    }

    public Date getUserPeriodTime() {
        return userPeriodTime;
    }

    public void setUserPeriodTime(Date userPeriodTime) {
        this.userPeriodTime = userPeriodTime;
    }

    public String getUserWorkTel() {
        return userWorkTel;
    }

    public void setUserWorkTel(String userWorkTel) {
        this.userWorkTel = userWorkTel;
    }

    public Integer getActiveStatus() {
        return activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getContactAddr() {
        return contactAddr;
    }

    public void setContactAddr(String contactAddr) {
        this.contactAddr = contactAddr;
    }

    public String getBusinessExtensionAttribute() {
        return businessExtensionAttribute;
    }

    public void setBusinessExtensionAttribute(String businessExtensionAttribute) {
        this.businessExtensionAttribute = businessExtensionAttribute;
    }
}
