package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xforceplus.domain.org.deserializer.OrgTypeDeserializer;
import com.xforceplus.domain.validation.ValidationGroup;
import com.xforceplus.tenant.security.core.domain.ICompany;
import com.xforceplus.tenant.security.core.domain.IOrg;
import com.xforceplus.tenant.security.core.domain.Org;
import com.xforceplus.tenant.security.core.domain.OrgType;
import io.geewit.core.jackson.databind.serializer.EnumValueSerializer;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(value = "组织")
public class OrgDto<O extends OrgDto<O>> extends Org implements IOrg, ICompany {

    @ApiModelProperty("组织id")
    protected Long orgId;

    @ApiModelProperty("组织编码")
    protected String orgCode;

    @ApiModelProperty("组织名称")
    protected String orgName;

    @NotNull(groups = ValidationGroup.OnCreate.class)
    @ApiModelProperty(value = "组织描述", example = "组织描述")
    @JsonView(View.class)
    protected String orgDesc;

    @ApiModelProperty("租户id")
    protected Long tenantId;

    @ApiModelProperty("公司id")
    protected Long companyId;

    @ApiModelProperty("上级组织id")
    protected Long parentId;

    @ApiModelProperty("上级组织id路径")
    protected String parentIds;

    @ApiModelProperty(value = "组织类型", notes = "1：公司 2：其他组织")
    protected OrgType orgType;

    @ApiModelProperty("税号")
    protected String taxNum;

    @ApiModelProperty("公司名称")
    protected String companyName;


    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty("上级组织")
    @JsonIgnore
    protected O parent;

    @ApiModelProperty("下级组织集合")
    @JsonIgnore
    protected List<O> children = new ArrayList<>();

    @ApiModelProperty("公司代码集合")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonView(View.Info.class)
    protected List<String> companyNos = new ArrayList<>();

    @JsonView(View.class)
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @JsonView(View.class)
    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    @JsonView(View.class)
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @JsonView(View.class)
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonView(View.class)
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    @JsonView(View.class)
    public String getOrgCode() {
        return orgCode;
    }

    @NotNull(groups = ValidationGroup.OnCreate.class)
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @JsonView(View.class)
    public String getOrgName() {
        return orgName;
    }

    @NotNull(groups = ValidationGroup.OnCreate.class)
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @JsonView(View.class)
    public String getParentIds() {
        return parentIds;
    }

    public void setParentIds(String parentIds) {
        this.parentIds = parentIds;
    }

    @JsonView(View.class)
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @JsonView(View.class)
    @JsonSerialize(using = EnumValueSerializer.class)
    public OrgType getOrgType() {
        return orgType;
    }

    @JsonDeserialize(using = OrgTypeDeserializer.class)
    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }

    public String getOrgDesc() {
        return orgDesc;
    }

    public void setOrgDesc(String orgDesc) {
        this.orgDesc = orgDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public O getParent() {
        return parent;
    }

    public void setParent(O parent) {
        this.parent = parent;
    }

    public List<O> getChildren() {
        return children;
    }

    public void setChildren(List<O> children) {
        this.children = children;
    }

    public List<String> getCompanyNos() {
        return companyNos;
    }

    public void setCompanyNos(List<String> companyNos) {
        this.companyNos = companyNos;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgDto<O> orgDto = (OrgDto<O>) o;
        return Objects.equals(orgId, orgDto.orgId) ||
                (tenantId.equals(orgDto.tenantId) &&
                        orgCode.equals(orgDto.orgCode));
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgId, tenantId, orgCode);
    }
}
