package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

@ApiModel("资源码")
public class ResourceDto<T extends ResourceDto<T>> {
    @ApiModelProperty("资源码id")
    @JsonView(View.class)
    protected Long resourceId;

    @ApiModelProperty("appid")
    @JsonView(View.class)
    protected Integer appId;

    @ApiModelProperty("资源码")
    @JsonView(View.class)
    protected String resourceCode;

    @ApiModelProperty("资源码名称")
    @JsonView(View.class)
    protected String resourceName;

    @ApiModelProperty("所属平台")
    @JsonView(View.class)
    protected Integer resourcePlatform;

    @ApiModelProperty("资源码类型")
    @JsonView(View.class)
    protected Integer resourceType;

    @ApiModelProperty("上级资源码id")
    @JsonView(View.class)
    protected Long parentId;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "是否属于公司服务包", notes = "1:是, 0:否")
    @JsonView(View.class)
    protected Boolean isServicePackage;

    @ApiModelProperty("下级资源码集合")
    @JsonView(View.Tree.class)
    protected List<T> children;

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Integer getAppId() {
        return appId;
    }

    public void setAppId(Integer appId) {
        this.appId = appId;
    }

    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getResourcePlatform() {
        return resourcePlatform;
    }

    public void setResourcePlatform(Integer resourcePlatform) {
        this.resourcePlatform = resourcePlatform;
    }

    public Integer getResourceType() {
        return resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Boolean getIsServicePackage() {
        return isServicePackage;
    }

    public void setIsServicePackage(Boolean isServicePackage) {
        this.isServicePackage = isServicePackage;
    }

    public List<T> getChildren() {
        return children;
    }

    public void setChildren(List<T> children) {
        this.children = children;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResourceDto that = (ResourceDto) o;
        return Objects.equals(resourceCode, that.resourceCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceCode);
    }
}
