package com.xforceplus.domain.settle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import io.geewit.web.utils.JsonUtils;

import javax.persistence.Transient;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettleFlowDto<T extends SettleTemplateDto<A>, A extends SettleTemplateAttributeDto> {
    protected Long flowId;
    protected String flowName;
    protected Long tenantId;
    protected String tenantCode;
    protected String rawProperties;
    protected String script;

    protected List<T> templates;

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public String getFlowName() {
        return flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @JsonIgnore
    public String getRawProperties() {
        return rawProperties;
    }

    public void setRawProperties(String rawProperties) {
        this.rawProperties = rawProperties;
    }

    public String getScript() {
        return script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<T> getTemplates() {
        return templates;
    }

    public void setTemplates(List<T> templates) {
        this.templates = templates;
    }

    @Transient
    public Map<String, Object> getProperties() {
        if (this.rawProperties != null) {
            try {
                Map<String, Object> properties = JsonUtils.fromJson(this.rawProperties, new TypeReference<Map<String, Object>>() {
                });
                return properties;
            } catch (Exception e) {
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SettleFlowDto that = (SettleFlowDto) o;
        return Objects.equals(flowId, that.flowId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(flowId);
    }

    @Override
    public String toString() {
        return "SettleFlowDto{" +
                "flowId=" + flowId +
                ", flowName='" + flowName + '\'' +
                ", tenantId=" + tenantId +
                ", tenantCode='" + tenantCode + '\'' +
                ", rawProperties='" + rawProperties + '\'' +
                ", script='" + script + '\'' +
                '}';
    }
}
