package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;


@ApiModel("功能集")
public class ResourcesetDto<RE extends ResourceDto> {

    @ApiModelProperty("功能集id")
    @JsonView(View.class)
    protected Long resourcesetId;

    @ApiModelProperty("appid")
    @JsonView(View.class)
    protected Long appId;

    @ApiModelProperty("功能集名称")
    @JsonView(View.class)
    protected String resourcesetName;

    @ApiModelProperty("功能集描述")
    @JsonView(View.class)
    protected String resourcesetDesc;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    public Long getResourcesetId() {
        return resourcesetId;
    }

    public void setResourcesetId(Long resourcesetId) {
        this.resourcesetId = resourcesetId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getResourcesetName() {
        return resourcesetName;
    }

    public void setResourcesetName(String resourcesetName) {
        this.resourcesetName = resourcesetName;
    }

    public String getResourcesetDesc() {
        return resourcesetDesc;
    }

    public void setResourcesetDesc(String resourcesetDesc) {
        this.resourcesetDesc = resourcesetDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResourcesetDto<?> that = (ResourcesetDto<?>) o;
        return Objects.equals(resourcesetId, that.resourcesetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourcesetId);
    }
}
