package com.xforceplus.domain.tenant;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel(value = "租户")
public class TenantDto {

    @ApiModelProperty(value = "租户id")
    protected Long tenantId;

    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @ApiModelProperty(value = "租户代码")
    protected String tenantCode;

    @ApiModelProperty(value = "租户描述")
    protected String tenantDesc;

    @ApiModelProperty(value = "入驻来源")
    protected String settledOrigin;

    protected String operateReason;

    @ApiModelProperty(value = "状态", notes = "1：启用 0：禁用")
    protected Integer status;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }


    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantDesc() {
        return tenantDesc;
    }

    public void setTenantDesc(String tenantDesc) {
        this.tenantDesc = tenantDesc;
    }

    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public String getSettledOrigin() {
        return settledOrigin;
    }

    public void setSettledOrigin(String settledOrigin) {
        this.settledOrigin = settledOrigin;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

}
