package com.xforceplus.domain.user;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.Role;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;


@ApiModel(value = "角色")
public class RoleDto extends Role {

    @ApiModelProperty(value = "角色描述")
    @JsonView(View.class)
    protected String roleDesc;


    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @ApiModelProperty(value = "更新操作人")
    @JsonView(View.class)
    protected String updateUserName;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonView(View.class)
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonView(View.class)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRoleDesc() {
        return roleDesc;
    }

    public void setRoleDesc(String roleDesc) {
        this.roleDesc = roleDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 废弃
     * @see #getName()
     * @return
     */
    @JsonView(View.class)
    @Deprecated
    public String getRoleName() {
        return this.name;
    }

    /**
     * 废弃
     * @see #getCode()
     * @return
     */
    @JsonView(View.class)
    @Deprecated
    public String getRoleCode() {
        return this.code;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RoleDto roleDto = (RoleDto) o;
        return Objects.equals(id, roleDto.id) ||
                (Objects.equals(code, roleDto.code) &&
                        Objects.equals(tenantId, roleDto.tenantId));
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, code, tenantId);
    }
}
