package com.xforceplus.domain.user;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Set;


@ApiModel(value = "用户")
public class UserDto<O extends OrgDto<O>, R extends RoleDto> extends UserRaw implements IAuthorizedUser<O, R> {
    @ApiModelProperty("公司集合")
    protected Set<O> companies;

    @ApiModelProperty("用户角色id集合")
    protected Set<R> roles;

    @ApiModelProperty("最近的上一级公司集合")
    protected Set<O> parentCompanies;

    @ApiModelProperty("资源码集合")
    protected Set<String> resourceCodes;

    @ApiModelProperty("所在租户开启的应用id集合")
    protected Set<Long> appIds;

    @ApiModelProperty("所属以及下级组织集合")
    protected Set<O> orgs;

    @ApiModelProperty("所在组织集合")
    protected Set<O> currentOrgs;

    @ApiModelProperty(value = "用户编码", notes = "预留给业务系统使用")
    @JsonView(View.class)
    protected String userNumber;

    @ApiModelProperty(value = "用户名称", notes = "预留给业务系统使用")
    @JsonView(View.class)
    protected String userName;

    @ApiModelProperty(value = "联系电话")
    @JsonView(View.class)
    protected String userPhone;

    @ApiModelProperty(value = "性别")
    @JsonView(View.class)
    protected Integer userSex;

    @JsonView(View.class)
    protected String userEmailAddr;

    @JsonView(View.class)
    protected String userIdCard;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08")
    @JsonView(View.class)
    protected Date userPeriodTime;

    @JsonView(View.class)
    protected String userWorkTel;

    @JsonView(View.class)
    protected Integer activeStatus;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(View.class)
    protected String contactAddr;

    @JsonView(View.class)
    protected String businessExtensionAttribute;

    public String getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(String userNumber) {
        this.userNumber = userNumber;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }

    public Integer getUserSex() {
        return userSex;
    }

    public void setUserSex(Integer userSex) {
        this.userSex = userSex;
    }

    public String getUserEmailAddr() {
        return userEmailAddr;
    }

    public void setUserEmailAddr(String userEmailAddr) {
        this.userEmailAddr = userEmailAddr;
    }

    public String getUserIdCard() {
        return userIdCard;
    }

    public void setUserIdCard(String userIdCard) {
        this.userIdCard = userIdCard;
    }

    public Date getUserPeriodTime() {
        return userPeriodTime;
    }

    public void setUserPeriodTime(Date userPeriodTime) {
        this.userPeriodTime = userPeriodTime;
    }

    public String getUserWorkTel() {
        return userWorkTel;
    }

    public void setUserWorkTel(String userWorkTel) {
        this.userWorkTel = userWorkTel;
    }

    public Integer getActiveStatus() {
        return activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getContactAddr() {
        return contactAddr;
    }

    public void setContactAddr(String contactAddr) {
        this.contactAddr = contactAddr;
    }

    public String getBusinessExtensionAttribute() {
        return businessExtensionAttribute;
    }

    public void setBusinessExtensionAttribute(String businessExtensionAttribute) {
        this.businessExtensionAttribute = businessExtensionAttribute;
    }

    public Set<O> getCompanies() {
        return companies;
    }

    public void setCompanies(Set<O> companies) {
        this.companies = companies;
    }

    public Set<R> getRoles() {
        return roles;
    }

    public void setRoles(Set<R> roles) {
        this.roles = roles;
    }

    public Set<O> getParentCompanies() {
        return parentCompanies;
    }

    public void setParentCompanies(Set<O> parentCompanies) {
        this.parentCompanies = parentCompanies;
    }

    @Override
    public Set<String> getResourceCodes() {
        return resourceCodes;
    }

    public void setResourceCodes(Set<String> resourceCodes) {
        this.resourceCodes = resourceCodes;
    }

    @Override
    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public Set<O> getOrgs() {
        return orgs;
    }

    public void setOrgs(Set<O> orgs) {
        this.orgs = orgs;
    }

    public Set<O> getCurrentOrgs() {
        return currentOrgs;
    }

    public void setCurrentOrgs(Set<O> currentOrgs) {
        this.currentOrgs = currentOrgs;
    }
}
