package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.Tag;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;
import java.util.Set;

/**
 * 权限角色
 * @author geewit
 */
public class RoleDto extends TokenRole {

    @ApiModelProperty(value = "角色描述")
    @JsonView(View.class)
    protected String roleDesc;

    @ApiModelProperty(value = "更新操作人")
    @JsonView(View.class)
    protected String updateUserName;

    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("角色标签集合")
    protected Set<Tag> tags;

    public String getRoleDesc() {
        return roleDesc;
    }

    public void setRoleDesc(String roleDesc) {
        this.roleDesc = roleDesc;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Set<Tag> getTags() {
        return tags;
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RoleDto role = (RoleDto) o;
        return id.equals(role.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return "Role{" +
                "id=" + id +
                ", tenantId=" + tenantId +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", tags=" + tags +
                '}';
    }
}
