package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.tenant.security.core.domain.Org;
import com.xforceplus.tenant.security.core.domain.OrgType;
import com.xforceplus.tenant.security.core.domain.view.OrgView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;


/**
 * 组织
 *
 * @author geewit
 */
@ApiModel("组织")
public class OrgDto<O extends OrgDto<O>> extends Org<O> {
    @JsonView(View.class)
    @ApiModelProperty(value = "组织描述")
    protected String orgDesc;

    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty("公司代码集合")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonView(OrgView.OrgInfo.class)
    protected List<String> companyNos = new ArrayList<>();

    @ApiModelProperty("组织扩展")
    private List<ExtensionDto> extensions;

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @Override
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @Override
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgDesc() {
        return orgDesc;
    }

    public void setOrgDesc(String orgDesc) {
        this.orgDesc = orgDesc;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }


    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getParentIds() {
        return parentIds;
    }

    public void setParentIds(String parentIds) {
        this.parentIds = parentIds;
    }

    @Override
    public OrgType getOrgType() {
        return orgType;
    }

    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }

    @Override
    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    @Override
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<String> getCompanyNos() {
        return companyNos;
    }

    public void setCompanyNos(List<String> companyNos) {
        this.companyNos = companyNos;
    }

    public List<ExtensionDto> getExtensions() {
        return extensions;
    }

    public void setExtensions(List<ExtensionDto> extensions) {
        this.extensions = extensions;
    }
}
