package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

@ApiModel(value = "服务包")
public class ServicePackageDto {
    @ApiModelProperty("服务包id")
    @JsonView(View.class)
    protected Long servicePackageId;
    @ApiModelProperty("appid")
    @JsonView(View.class)
    protected Long appId;
    @ApiModelProperty("服务包名称")
    @JsonView(View.class)
    protected String servicePackageName;
    @ApiModelProperty("服务包描述")
    @JsonView(View.class)
    protected String servicePackageDesc;
    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @Range(max = 1L)
    @JsonView(View.class)
    protected Integer status;

    public ServicePackageDto() {
    }

    public ServicePackageDto(Long servicePackageId, String servicePackageName) {
        this.servicePackageId = servicePackageId;
        this.servicePackageName = servicePackageName;
    }

    public Long getServicePackageId() {
        return servicePackageId;
    }

    public void setServicePackageId(Long servicePackageId) {
        this.servicePackageId = servicePackageId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getServicePackageName() {
        return servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public String getServicePackageDesc() {
        return servicePackageDesc;
    }

    public void setServicePackageDesc(String servicePackageDesc) {
        this.servicePackageDesc = servicePackageDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
