package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@ApiModel(value = "组织扩展")
@Data
public class ExtensionDto {

    @ApiModelProperty("扩展字段key")
    @JsonView(View.class)
    protected String extensionKey;

    @ApiModelProperty("扩展字段value")
    @JsonView(View.class)
    protected String extensionValue;

    @ApiModelProperty(value = "状态", example = "1", notes = "1:启用, 2:作废")
    @JsonView(View.class)
    protected Integer status;
}
