package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.validation.ValidationGroup;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

@ApiModel(value = "服务包")
public class ServicePackageDto {
    @ApiModelProperty("服务包id")
    @JsonView(View.class)
    protected Long servicePackageId;
    @ApiModelProperty("appid")
    @JsonView(View.class)
    @Min(1)
    @NotNull(groups = ValidationGroup.OnCreate.class)
    protected Long appId;
    @ApiModelProperty("服务包code")
    @JsonView(View.class)
    protected String servicePackageCode;
    @ApiModelProperty("服务包名称")
    @JsonView(View.class)
    @NotEmpty(groups = ValidationGroup.OnCreate.class)
    protected String servicePackageName;
    @ApiModelProperty("服务包描述")
    @JsonView(View.class)
    protected String servicePackageDesc;
    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @Range(max = 1L)
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "创建时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    protected Date createTime;

    public ServicePackageDto() {
    }

    public ServicePackageDto(Long servicePackageId, String servicePackageName) {
        this.servicePackageId = servicePackageId;
        this.servicePackageName = servicePackageName;
    }

    public Long getServicePackageId() {
        return servicePackageId;
    }

    public void setServicePackageId(Long servicePackageId) {
        this.servicePackageId = servicePackageId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getServicePackageCode() {
        return servicePackageCode;
    }

    public void setServicePackageCode(String servicePackageCode) {
        this.servicePackageCode = servicePackageCode;
    }

    public String getServicePackageName() {
        return servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public String getServicePackageDesc() {
        return servicePackageDesc;
    }

    public void setServicePackageDesc(String servicePackageDesc) {
        this.servicePackageDesc = servicePackageDesc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
