/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.google.common.base.Splitter;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.tenant.security.core.domain.Org;
import com.xforceplus.tenant.security.core.domain.OrgType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgUtils {
    private static final Logger logger = LoggerFactory.getLogger(OrgUtils.class);
    private static final String SPLIT_OF_ORG_PARENT_IDS = Arrays.stream(OrgType.values()).map(OrgType::separator).collect(Collectors.joining("|", "[", "]"));
    private static final Pattern SPLIT_PATTERN_OF_ORG_PARENT_IDS = Pattern.compile(SPLIT_OF_ORG_PARENT_IDS);
    private static final Map<OrgType, Pattern> SPLIT_PATTERN_OF_ORG_PARENT_IDS_MAP = Arrays.stream(OrgType.values()).collect(Collectors.toMap(Function.identity(), orgType -> Pattern.compile("(\\d+)[" + orgType.separator() + "]")));

    public static Set<Long> findOrgIdInParentIds(String parentIds) {
        if (StringUtils.isBlank((CharSequence)parentIds)) {
            return Collections.emptySet();
        }
        Set<Long> orgIds = Splitter.on((Pattern)SPLIT_PATTERN_OF_ORG_PARENT_IDS).omitEmptyStrings().trimResults().splitToStream((CharSequence)parentIds).filter(NumberUtils::isDigits).map(v -> {
            try {
                return Long.parseLong(v);
            }
            catch (NumberFormatException e) {
                logger.info("{}, value: {}", (Object)e.getMessage(), v);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        return orgIds;
    }

    public static Set<Long> findNextOrgIdInParentIdsByParentId(Set<String> parentIdsSet, long parentId) {
        Pattern pattern = Pattern.compile(parentId + SPLIT_OF_ORG_PARENT_IDS + "(\\d+)" + SPLIT_OF_ORG_PARENT_IDS);
        return parentIdsSet.stream().map(parentIds -> {
            Matcher matcher = pattern.matcher((CharSequence)parentIds);
            if (matcher.find()) {
                String group = matcher.group(1);
                try {
                    return Long.parseLong(group);
                }
                catch (NumberFormatException e) {
                    logger.info("{}, value: {}", (Object)e.getMessage(), (Object)group);
                    return null;
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Long> findOrgIdsInParentIdsByOrgType(String parentIds, OrgType orgType, boolean findFirst) {
        logger.debug("parentIds = " + parentIds);
        if (StringUtils.isBlank((CharSequence)parentIds)) {
            return Collections.emptySet();
        }
        Matcher matcher = SPLIT_PATTERN_OF_ORG_PARENT_IDS_MAP.get(orgType).matcher(parentIds);
        HashSet<Long> orgIds = new HashSet<Long>();
        while (matcher.find()) {
            String group = matcher.group(1);
            try {
                long orgId = Long.parseLong(group);
                orgIds.add(orgId);
                if (logger.isDebugEnabled()) {
                    logger.debug("orgId = " + orgId);
                }
                if (!findFirst || orgId <= 0L) continue;
                break;
            }
            catch (NumberFormatException e) {
                logger.info("{}, value: {}", (Object)e.getMessage(), (Object)group);
            }
        }
        return orgIds;
    }

    public static Set<Long> findCompanyOrgIdsInParentIds(String parentIds) {
        Set<Long> orgIds = OrgUtils.findOrgIdsInParentIdsByOrgType(parentIds, OrgType.COMPANY, false);
        return orgIds;
    }

    public static Long findRootIdInParentIds(String parentIds) {
        Set<Long> orgIds = OrgUtils.findOrgIdsInParentIdsByOrgType(parentIds, OrgType.GROUP, true);
        return (Long)orgIds.stream().findFirst().orElseGet(null);
    }

    public static Set<String> compressParentIdsCollection(Collection<String> parentIdsCollection) {
        if (parentIdsCollection == null) {
            return Collections.emptySet();
        }
        if (parentIdsCollection.isEmpty()) {
            if (parentIdsCollection instanceof Set) {
                return (Set)parentIdsCollection;
            }
            return Collections.emptySet();
        }
        Stack parentIdsStack = new Stack();
        parentIdsCollection.stream().filter(StringUtils::isNotBlank).sorted(String::compareTo).forEach(currentParentIds -> {
            if (parentIdsStack.isEmpty()) {
                parentIdsStack.push(currentParentIds);
            } else {
                String parentIds = (String)parentIdsStack.pop();
                if (!parentIds.equals(currentParentIds)) {
                    if (parentIds.startsWith((String)currentParentIds)) {
                        parentIdsStack.push(currentParentIds);
                    } else if (currentParentIds.startsWith(parentIds)) {
                        parentIdsStack.push(parentIds);
                    } else {
                        parentIdsStack.push(parentIds);
                        parentIdsStack.push(currentParentIds);
                    }
                } else {
                    parentIdsStack.push(parentIds);
                }
            }
        });
        return parentIdsStack.stream().collect(Collectors.toSet());
    }

    public static Set<Long> excludeInParentIds(Collection<Long> orgIds, Collection<String> parentIdsCollection) {
        if (orgIds == null) {
            return Collections.emptySet();
        }
        Set<Long> filteredOrgIds = orgIds instanceof Set ? (HashSet<Long>)orgIds : new HashSet<Long>(orgIds);
        if (CollectionUtils.isEmpty(filteredOrgIds)) {
            return filteredOrgIds;
        }
        if (CollectionUtils.isEmpty(parentIdsCollection)) {
            return filteredOrgIds;
        }
        for (String parentIds : parentIdsCollection) {
            String filterParentIdsWithoutLastSperator = StringUtils.substring((String)parentIds, (int)0, (int)(parentIds.length() - 1));
            filteredOrgIds = filteredOrgIds.stream().filter(id -> !StringUtils.endsWith((CharSequence)filterParentIdsWithoutLastSperator, (CharSequence)String.valueOf(id))).collect(Collectors.toSet());
        }
        return filteredOrgIds;
    }

    public static Pair<Set<String>, Set<Long>> compressParentIdsCollectionAndFilterOrgIds(Collection<String> parentIdsCollection, Collection<Long> orgIds) {
        HashSet<Long> filteredOrgIds = orgIds == null ? Collections.emptySet() : (orgIds instanceof Set ? (HashSet<Long>)orgIds : new HashSet<Long>(orgIds));
        Stack parentIdsStack = new Stack();
        HashSet<Long> finalFilteredOrgIds = filteredOrgIds;
        parentIdsCollection.stream().filter(StringUtils::isNotBlank).sorted(String::compareTo).forEach(currentParentIds -> {
            if (parentIdsStack.isEmpty()) {
                parentIdsStack.push(currentParentIds);
            } else {
                String parentIds = (String)parentIdsStack.pop();
                OrgUtils.filterOrgIdsInParentIds(finalFilteredOrgIds, currentParentIds);
                if (!parentIds.equals(currentParentIds)) {
                    if (parentIds.startsWith((String)currentParentIds)) {
                        parentIdsStack.push(currentParentIds);
                    } else if (currentParentIds.startsWith(parentIds)) {
                        parentIdsStack.push(parentIds);
                    } else {
                        parentIdsStack.push(parentIds);
                        parentIdsStack.push(currentParentIds);
                    }
                } else {
                    parentIdsStack.push(parentIds);
                }
            }
        });
        Set parentIdsSet = parentIdsStack.stream().collect(Collectors.toSet());
        return Pair.of(parentIdsSet, filteredOrgIds);
    }

    public static void filterOrgIdsInParentIds(Set<Long> orgIds, String parentIds) {
        if (CollectionUtils.isNotEmpty(orgIds) && StringUtils.isNotBlank((CharSequence)parentIds)) {
            String finalParentIds = StringUtils.substring((String)parentIds, (int)0, (int)(parentIds.length() - 1));
            Set filteredOrgIds = orgIds.stream().filter(id -> !StringUtils.endsWith((CharSequence)finalParentIds, (CharSequence)String.valueOf(id))).collect(Collectors.toSet());
            orgIds.clear();
            orgIds.addAll(filteredOrgIds);
        }
    }

    public static <O extends OrgDto<O>> Set<String> filterParentIdsByModules(long tenantId, String modules, List<O> orgs) {
        Object[] orgCodeArray = StringUtils.split((String)modules, (String)",");
        if (ArrayUtils.isEmpty((Object[])orgCodeArray)) {
            return Collections.emptySet();
        }
        Set orgCodes = Stream.of(orgCodeArray).filter(Objects::nonNull).collect(Collectors.toSet());
        List<String> filteringParentIdsList = orgs.stream().filter(o -> o.getTenantId() != null && tenantId == o.getTenantId() && orgCodes.stream().anyMatch(code -> code.equals(o.getOrgCode()))).map(Org::getParentIds).collect(Collectors.toList());
        return OrgUtils.compressParentIdsCollection(filteringParentIdsList);
    }

    public static <O extends OrgDto<O>> Map<Long, Map<Long, Integer>> bindUsers(List<O> orgs, long orgId, Map<Long, Integer> userIdRelTypeMap) {
        OrgDto org = orgs.stream().filter(o -> Objects.equals(o.getId(), orgId)).findFirst().orElseThrow(() -> new IllegalArgumentException("\u672a\u5728\u6743\u9650\u8303\u56f4\u5185\u627e\u5230\u6307\u5b9a\u7ec4\u7ec7(id:" + orgId + ")"));
        String parentIds = org.getParentIds();
        orgs = orgs.stream().filter(o -> StringUtils.startsWith((CharSequence)o.getParentIds(), (CharSequence)parentIds)).collect(Collectors.toList());
        HashMap<Long, Map<Long, Integer>> result = new HashMap<Long, Map<Long, Integer>>();
        for (OrgDto orgDto : orgs) {
            Map existUserIdRelTypeMap = (Map)result.get(orgDto.getId());
            if (existUserIdRelTypeMap == null) {
                result.put((Long)org.getId(), userIdRelTypeMap);
                continue;
            }
            for (Map.Entry<Long, Integer> entry : userIdRelTypeMap.entrySet()) {
                if (entry.getValue() != 1) continue;
                existUserIdRelTypeMap.merge(entry.getKey(), entry.getValue(), (a, b) -> a | b);
            }
            result.put((Long)org.getId(), existUserIdRelTypeMap);
        }
        return result;
    }
}

