package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Date;

@ApiModel("服务Api接口")
public class ServiceApiDto implements IOperator {
    @ApiModelProperty(value = "服务Api接口id")
    protected Long serviceApiId;

    @ApiModelProperty(value = "服务Api接口类名路径")
    protected String serviceApiPath;

    @ApiModelProperty(value = "请求url")
    protected String serviceApiUrl;

    @ApiModelProperty(value = "Http请求方法")
    protected RequestMethod requestMethod;

    @ApiModelProperty(value = "appid")
    protected Long appId;

    @ApiModelProperty("appName")
    @JsonView(View.class)
    protected String appName;

    @ApiModelProperty(value = "路由id")
    protected Long routeId;

    @ApiModelProperty(value = "跳过鉴权", notes = "1:跳过, 0:不跳过")
    protected Boolean skipAuth;

    @ApiModelProperty(value = "跳过认证", notes = "1:跳过, 0:不跳过")
    protected Boolean skipCheck;

    @ApiModelProperty(value = "服务Api接口名称")
    protected String serviceApiName;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    protected Integer status;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    public Long getServiceApiId() {
        return serviceApiId;
    }

    public void setServiceApiId(Long serviceApiId) {
        this.serviceApiId = serviceApiId;
    }

    public String getServiceApiPath() {
        return serviceApiPath;
    }

    public void setServiceApiPath(String serviceApiPath) {
        this.serviceApiPath = serviceApiPath;
    }

    public String getServiceApiUrl() {
        return serviceApiUrl;
    }

    public void setServiceApiUrl(String serviceApiUrl) {
        this.serviceApiUrl = serviceApiUrl;
    }

    public RequestMethod getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Long getRouteId() {
        return routeId;
    }

    public void setRouteId(Long routeId) {
        this.routeId = routeId;
    }

    public Boolean getSkipAuth() {
        return skipAuth;
    }

    public void setSkipAuth(Boolean skipAuth) {
        this.skipAuth = skipAuth;
    }

    public Boolean getSkipCheck() {
        return skipCheck;
    }

    public void setSkipCheck(Boolean skipCheck) {
        this.skipCheck = skipCheck;
    }

    public String getServiceApiName() {
        return serviceApiName;
    }

    public void setServiceApiName(String serviceApiName) {
        this.serviceApiName = serviceApiName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String getCreaterId() {
        return createrId;
    }

    @Override
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @Override
    public String getCreaterName() {
        return createrName;
    }

    @Override
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
