package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;


@ApiModel(value = "租户")
public class TenantDto implements IOperator {
    @JsonView({View.class})
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;

    @JsonView({View.class})
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @JsonView({View.class})
    @ApiModelProperty(value = "租户代码")
    protected String tenantCode;

    @JsonView({View.class})
    @ApiModelProperty(value = "租户描述")
    protected String tenantDesc;

    @JsonView({View.class})
    @ApiModelProperty(value = "入驻来源")
    protected String settledOrigin;

    @JsonView({View.class})
    protected String operateReason;

    @JsonView({View.class})
    @ApiModelProperty(value = "状态", notes = "1：启用 0：禁用")
    protected Integer status;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    protected Date updateTime;

    @JsonView({View.class})
    protected Integer companyCount;

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }


    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantDesc() {
        return tenantDesc;
    }

    public void setTenantDesc(String tenantDesc) {
        this.tenantDesc = tenantDesc;
    }

    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public String getSettledOrigin() {
        return settledOrigin;
    }

    public void setSettledOrigin(String settledOrigin) {
        this.settledOrigin = settledOrigin;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreaterId() {
        return createrId;
    }

    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    public String getCreaterName() {
        return createrName;
    }

    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getCompanyCount() {
        return companyCount;
    }

    public void setCompanyCount(Integer companyCount) {
        this.companyCount = companyCount;
    }

    @JsonView(View.class)
    @ApiModelProperty("租户扩展")
    private List<TenantExtensionDto> extensions;

    public List<TenantExtensionDto> getExtensions() {
        return extensions;
    }

    public void setExtensions(List<TenantExtensionDto> extensions) {
        this.extensions = extensions;
    }
}
