package com.xforceplus.domain.settle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Data
public class SettleStepDto {

    protected String taxNum;
    protected String templateCode;
    protected String paramsJson;
    protected Integer stepStatus;
    private Long orgId;
    private String orgName;
    private Long CompanyId;
    @JsonIgnore
    protected Long flowId;
    protected String companyName;
    protected Long tenantId;

    public SettleStepDto(){}
    public static SettleStepDto build(SettleStepDto settleStep) {
        SettleStepDto settle = new SettleStepDto();
        settle.setCompanyName(settleStep.getCompanyName());
        settle.setFlowId(settleStep.getFlowId());
        settle.setParamsJson(settleStep.getParamsJson());
        settle.setStepStatus(settleStep.getStepStatus());
        settle.setTaxNum(settleStep.getTaxNum());
        settle.setTemplateCode(settleStep.getTemplateCode());
        settle.setTenantId(settleStep.getTenantId());
       return  settle;
    }
}
