package com.xforceplus.domain.settle;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.resource.ServicePackageDto;
import io.geewit.core.jackson.view.View;

import java.util.Objects;

public class SettleFlowPackageDto<P extends ServicePackageDto> {
    @JsonView(View.class)
    protected Long id;

    @JsonView(View.class)
    protected Long flowId;

    @JsonView(View.class)
    protected Long packageId;

    @JsonView(View.class)
    protected P servicePackage;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getFlowId() {
        return flowId;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public P getServicePackage() {
        return servicePackage;
    }

    public void setServicePackage(P servicePackage) {
        this.servicePackage = servicePackage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SettleFlowPackageDto that = (SettleFlowPackageDto) o;
        return Objects.equals(flowId, that.flowId) && Objects.equals(packageId, that.packageId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
