package com.xforceplus.domain.tenant;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.IOperator;
import com.xforceplus.domain.resource.ResourcesetDto;
import com.xforceplus.domain.tenant.view.SysRole;
import com.xforceplus.tenant.security.core.domain.Tag;
import com.xforceplus.tenant.security.core.domain.view.RoleView;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * 权限角色
 * @author geewit
 */
public class RoleDto<RS extends ResourcesetDto> extends TokenRole implements IOperator {

    @ApiModelProperty(value = "角色描述")
    @JsonView(View.class)
    protected String roleDesc;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;


    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    protected Date updateTime;

    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("角色标签集合")
    protected Set<Tag> tags;

    @JsonView(SysRole.class)
    @ApiModelProperty("租户集合")
    protected Set<Long> tenantIds;

    @JsonView(SysRole.class)
    @ApiModelProperty("租户集合")
    protected Set<Long> resourcesetIds;

    @JsonView(RoleView.RoleInfo.class)
    @ApiModelProperty("功能集集合")
    protected Set<RS> resourcesets;

    @ApiModelProperty(value = "来源角色id")
    @JsonView(View.class)
    protected Long fromRoleId;

    public String getRoleDesc() {
        return roleDesc;
    }

    public void setRoleDesc(String roleDesc) {
        this.roleDesc = roleDesc;
    }

    public void setRoleCode(String roleCode) {
        this.code = roleCode;
    }

    public void setRoleName(String roleName) {
        this.name = roleName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreaterId() {
        return createrId;
    }

    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    public String getCreaterName() {
        return createrName;
    }

    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdaterId() {
        return updaterId;
    }

    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    public String getUpdaterName() {
        return updaterName;
    }

    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Set<Tag> getTags() {
        return tags;
    }

    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    public Set<Long> getTenantIds() {
        return tenantIds;
    }

    public void setTenantIds(Set<Long> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @JsonView(SysRole.class)
    @ApiModelProperty("功能集id集合")
    public Set<Long> getResourcesetIds() {
        if(null != resourcesetIds){
            return resourcesetIds;
        }
        if(null != this.getResourcesets()){
            resourcesetIds = this.getResourcesets().stream().map(RS::getResourcesetId).collect(Collectors.toSet());
        }
        return resourcesetIds;
    }

    public Set<RS> getResourcesets() {
        return resourcesets;
    }

    public void setResourcesets(Set<RS> resourcesets) {
        this.resourcesets = resourcesets;
    }

    public Long getFromRoleId() {
        return fromRoleId;
    }

    public void setFromRoleId(Long fromRoleId) {
        this.fromRoleId = fromRoleId;
    }

    public void setResourcesetIds(Set<Long> resourcesetIds) {
        this.resourcesetIds = resourcesetIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RoleDto role = (RoleDto) o;
        return id.equals(role.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return "Role{" +
                "id=" + id +
                ", tenantId=" + tenantId +
                ", code='" + code + '\'' +
                ", name='" + name + '\'' +
                ", tags=" + tags +
                '}';
    }
}
